/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.PhysicalType;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;

class VariantExpressionUtil {
    private static final Map<Type, PhysicalType> NO_CONVERSION_NEEDED = ImmutableMap.builder().put(Types.IntegerType.get(), PhysicalType.INT32).put((Types.IntegerType)((Object)Types.LongType.get()), PhysicalType.INT64).put((Types.IntegerType)((Object)Types.FloatType.get()), PhysicalType.FLOAT).put((Types.IntegerType)((Object)Types.DoubleType.get()), PhysicalType.DOUBLE).put((Types.IntegerType)((Object)Types.DateType.get()), PhysicalType.DATE).put((Types.IntegerType)((Object)Types.TimestampType.withoutZone()), PhysicalType.TIMESTAMPNTZ).put((Types.IntegerType)((Object)Types.TimestampType.withZone()), PhysicalType.TIMESTAMPTZ).put((Types.IntegerType)((Object)Types.StringType.get()), PhysicalType.STRING).put((Types.IntegerType)((Object)Types.BinaryType.get()), PhysicalType.BINARY).put((Types.IntegerType)((Object)Types.UnknownType.get()), PhysicalType.NULL).build();

    private VariantExpressionUtil() {
    }

    static <T> T castTo(VariantValue value, Type type) {
        if (value == null) {
            return null;
        }
        if (NO_CONVERSION_NEEDED.get(type) == value.type()) {
            return (T)value.asPrimitive().get();
        }
        switch (type.typeId()) {
            case INTEGER: {
                switch (value.type()) {
                    case INT8: 
                    case INT16: {
                        return (T)Integer.valueOf(((Number)value.asPrimitive().get()).intValue());
                    }
                }
                break;
            }
            case LONG: {
                switch (value.type()) {
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        return (T)Long.valueOf(((Number)value.asPrimitive().get()).longValue());
                    }
                }
                break;
            }
            case DOUBLE: {
                if (value.type() != PhysicalType.FLOAT) break;
                return (T)Double.valueOf(((Number)value.asPrimitive().get()).doubleValue());
            }
            case FIXED: {
                ByteBuffer buffer;
                Types.FixedType fixedType = (Types.FixedType)type;
                if (value.type() != PhysicalType.BINARY || (buffer = (ByteBuffer)value.asPrimitive().get()).remaining() != fixedType.length()) break;
                return (T)buffer;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                switch (value.type()) {
                    case DECIMAL4: 
                    case DECIMAL8: 
                    case DECIMAL16: {
                        BigDecimal decimalValue = (BigDecimal)value.asPrimitive().get();
                        if (decimalValue.scale() != decimalType.scale()) break;
                        return (T)decimalValue;
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (value.type()) {
                    case BOOLEAN_FALSE: {
                        return (T)Boolean.FALSE;
                    }
                    case BOOLEAN_TRUE: {
                        return (T)Boolean.TRUE;
                    }
                }
            }
        }
        return null;
    }
}

