/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.inmemory;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;

public class InMemoryInputFile
implements InputFile {
    private final String location;
    private final byte[] contents;

    public InMemoryInputFile(byte[] contents) {
        this("memory:" + String.valueOf(UUID.randomUUID()), contents);
    }

    public InMemoryInputFile(String location, byte[] contents) {
        Preconditions.checkNotNull(location, "location is null");
        Preconditions.checkNotNull(contents, "contents is null");
        this.location = location;
        this.contents = (byte[])contents.clone();
    }

    @Override
    public long getLength() {
        return this.contents.length;
    }

    @Override
    public SeekableInputStream newStream() {
        return new InMemorySeekableInputStream(this.contents);
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public boolean exists() {
        return true;
    }

    private static class InMemorySeekableInputStream
    extends SeekableInputStream {
        private final long length;
        private final ByteArrayInputStream delegate;
        private boolean closed = false;

        InMemorySeekableInputStream(byte[] contents) {
            this.length = contents.length;
            this.delegate = new ByteArrayInputStream(contents);
        }

        @Override
        public long getPos() throws IOException {
            this.checkOpen();
            return this.length - (long)this.delegate.available();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.checkOpen();
            this.delegate.reset();
            Preconditions.checkState(this.delegate.skip(newPos) == newPos, "Invalid position %s within stream of length %s", newPos, this.length);
        }

        @Override
        public int read() {
            this.checkOpen();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.checkOpen();
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            this.checkOpen();
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) {
            this.checkOpen();
            return this.delegate.skip(n);
        }

        @Override
        public int available() {
            this.checkOpen();
            return this.delegate.available();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.checkOpen();
            this.delegate.reset();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }

        private void checkOpen() {
            Preconditions.checkState(!this.closed, "Stream is closed");
        }
    }
}

