/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.DeleteGranularity;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.EqualityDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.SortingPositionOnlyDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppenderFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.TaskWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.WriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructProjection;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskWriter<T>
implements TaskWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTaskWriter.class);
    private final List<DataFile> completedDataFiles = Lists.newArrayList();
    private final List<DeleteFile> completedDeleteFiles = Lists.newArrayList();
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private final PartitionSpec spec;
    private final FileFormat format;
    private final FileAppenderFactory<T> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSize;
    private Throwable failure;

    protected BaseTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        this.spec = spec;
        this.format = format;
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSize = targetFileSize;
    }

    protected PartitionSpec spec() {
        return this.spec;
    }

    protected void setFailure(Throwable throwable) {
        if (this.failure == null) {
            this.failure = throwable;
        }
    }

    @Override
    public void abort() throws IOException {
        this.close();
        Tasks.foreach(Iterables.concat(this.completedDataFiles, this.completedDeleteFiles)).executeWith(ThreadPools.getWorkerPool()).throwFailureWhenFinished().noRetry().run(file -> this.io.deleteFile(file.location()));
    }

    @Override
    public WriteResult complete() throws IOException {
        this.close();
        Preconditions.checkState(this.failure == null, "Cannot return results from failed writer", (Object)this.failure);
        return WriteResult.builder().addDataFiles(this.completedDataFiles).addDeleteFiles(this.completedDeleteFiles).addReferencedDataFiles(this.referencedDataFiles).build();
    }

    protected class RollingEqDeleteWriter
    extends BaseRollingWriter<EqualityDeleteWriter<T>> {
        RollingEqDeleteWriter(StructLike partitionKey) {
            super(partitionKey);
        }

        @Override
        EqualityDeleteWriter<T> newWriter(EncryptedOutputFile file, StructLike partitionKey) {
            return BaseTaskWriter.this.appenderFactory.newEqDeleteWriter(file, BaseTaskWriter.this.format, partitionKey);
        }

        @Override
        long length(EqualityDeleteWriter<T> writer) {
            return writer.length();
        }

        @Override
        void write(EqualityDeleteWriter<T> writer, T record) {
            writer.write(record);
        }

        @Override
        void complete(EqualityDeleteWriter<T> closedWriter) {
            BaseTaskWriter.this.completedDeleteFiles.add(closedWriter.toDeleteFile());
        }
    }

    protected class RollingFileWriter
    extends BaseRollingWriter<DataWriter<T>> {
        public RollingFileWriter(StructLike partitionKey) {
            super(partitionKey);
        }

        @Override
        DataWriter<T> newWriter(EncryptedOutputFile file, StructLike partitionKey) {
            return BaseTaskWriter.this.appenderFactory.newDataWriter(file, BaseTaskWriter.this.format, partitionKey);
        }

        @Override
        long length(DataWriter<T> writer) {
            return writer.length();
        }

        @Override
        void write(DataWriter<T> writer, T record) {
            writer.write(record);
        }

        @Override
        void complete(DataWriter<T> closedWriter) {
            BaseTaskWriter.this.completedDataFiles.add(closedWriter.toDataFile());
        }
    }

    private abstract class BaseRollingWriter<W extends Closeable>
    implements Closeable {
        private static final int ROWS_DIVISOR = 1000;
        private final StructLike partitionKey;
        private EncryptedOutputFile currentFile = null;
        private W currentWriter = null;
        private long currentRows = 0L;

        private BaseRollingWriter(StructLike partitionKey) {
            this.partitionKey = partitionKey;
            this.openCurrent();
        }

        abstract W newWriter(EncryptedOutputFile var1, StructLike var2);

        abstract long length(W var1);

        abstract void write(W var1, T var2);

        abstract void complete(W var1);

        public void write(T record) throws IOException {
            this.write(this.currentWriter, record);
            ++this.currentRows;
            if (this.shouldRollToNewFile()) {
                this.closeCurrent();
                this.openCurrent();
            }
        }

        public CharSequence currentPath() {
            Preconditions.checkNotNull(this.currentFile, "The currentFile shouldn't be null");
            return this.currentFile.encryptingOutputFile().location();
        }

        public long currentRows() {
            return this.currentRows;
        }

        private void openCurrent() {
            this.currentFile = this.partitionKey == null ? BaseTaskWriter.this.fileFactory.newOutputFile() : BaseTaskWriter.this.fileFactory.newOutputFile(this.partitionKey);
            this.currentWriter = this.newWriter(this.currentFile, this.partitionKey);
            this.currentRows = 0L;
        }

        private boolean shouldRollToNewFile() {
            return this.currentRows % 1000L == 0L && this.length(this.currentWriter) >= BaseTaskWriter.this.targetFileSize;
        }

        private void closeCurrent() throws IOException {
            if (this.currentWriter != null) {
                try {
                    this.currentWriter.close();
                    if (this.currentRows == 0L) {
                        Tasks.foreach(this.currentFile.encryptingOutputFile()).suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Failed to delete the uncommitted empty file during writer clean up: {}", file, (Object)exc)).run(BaseTaskWriter.this.io::deleteFile);
                    } else {
                        this.complete(this.currentWriter);
                    }
                }
                catch (IOException | RuntimeException e) {
                    BaseTaskWriter.this.setFailure(e);
                    throw e;
                }
                finally {
                    this.currentFile = null;
                    this.currentWriter = null;
                    this.currentRows = 0L;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.closeCurrent();
        }
    }

    private static class PathOffset {
        private final CharSequence path;
        private final long rowOffset;

        private PathOffset(CharSequence path, long rowOffset) {
            this.path = path;
            this.rowOffset = rowOffset;
        }

        private static PathOffset of(CharSequence path, long rowOffset) {
            return new PathOffset(path, rowOffset);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("path", this.path).add("row_offset", this.rowOffset).toString();
        }
    }

    protected abstract class BaseEqualityDeltaWriter
    implements Closeable {
        private final StructProjection structProjection;
        private final PositionDelete<T> positionDelete;
        private RollingFileWriter dataWriter;
        private RollingEqDeleteWriter eqDeleteWriter;
        private FileWriter<PositionDelete<T>, DeleteWriteResult> posDeleteWriter;
        private Map<StructLike, PathOffset> insertedRowMap;

        protected BaseEqualityDeltaWriter(StructLike partition, Schema schema, Schema deleteSchema) {
            this(partition, schema, deleteSchema, DeleteGranularity.PARTITION);
        }

        protected BaseEqualityDeltaWriter(StructLike partition, Schema schema, Schema deleteSchema, DeleteGranularity deleteGranularity) {
            Preconditions.checkNotNull(schema, "Iceberg table schema cannot be null.");
            Preconditions.checkNotNull(deleteSchema, "Equality-delete schema cannot be null.");
            this.structProjection = StructProjection.create(schema, deleteSchema);
            this.positionDelete = PositionDelete.create();
            this.dataWriter = new RollingFileWriter(partition);
            this.eqDeleteWriter = new RollingEqDeleteWriter(partition);
            this.posDeleteWriter = new SortingPositionOnlyDeleteWriter(() -> BaseTaskWriter.this.appenderFactory.newPosDeleteWriter(this.newOutputFile(partition), BaseTaskWriter.this.format, partition), deleteGranularity);
            this.insertedRowMap = StructLikeMap.create(deleteSchema.asStruct());
        }

        protected abstract StructLike asStructLike(T var1);

        protected abstract StructLike asStructLikeKey(T var1);

        public void write(T row) throws IOException {
            PathOffset pathOffset = PathOffset.of(this.dataWriter.currentPath(), this.dataWriter.currentRows());
            StructLike copiedKey = StructLikeUtil.copy(this.structProjection.wrap(this.asStructLike(row)));
            PathOffset previous = this.insertedRowMap.put(copiedKey, pathOffset);
            if (previous != null) {
                this.writePosDelete(previous);
            }
            this.dataWriter.write(row);
        }

        private EncryptedOutputFile newOutputFile(StructLike partition) {
            if (BaseTaskWriter.this.spec.isUnpartitioned() || partition == null) {
                return BaseTaskWriter.this.fileFactory.newOutputFile();
            }
            return BaseTaskWriter.this.fileFactory.newOutputFile(BaseTaskWriter.this.spec, partition);
        }

        private void writePosDelete(PathOffset pathOffset) {
            this.positionDelete.set(pathOffset.path, pathOffset.rowOffset, null);
            this.posDeleteWriter.write(this.positionDelete);
        }

        private boolean internalPosDelete(StructLike key) {
            PathOffset previous = this.insertedRowMap.remove(key);
            if (previous != null) {
                this.writePosDelete(previous);
                return true;
            }
            return false;
        }

        public void delete(T row) throws IOException {
            if (!this.internalPosDelete(this.structProjection.wrap(this.asStructLike(row)))) {
                this.eqDeleteWriter.write(row);
            }
        }

        public void deleteKey(T key) throws IOException {
            if (!this.internalPosDelete(this.asStructLikeKey(key))) {
                this.eqDeleteWriter.write(key);
            }
        }

        @Override
        public void close() throws IOException {
            block16: {
                try {
                    if (this.dataWriter != null) {
                        try {
                            this.dataWriter.close();
                        }
                        finally {
                            this.dataWriter = null;
                        }
                    }
                    if (this.eqDeleteWriter != null) {
                        try {
                            this.eqDeleteWriter.close();
                        }
                        finally {
                            this.eqDeleteWriter = null;
                        }
                    }
                    if (this.insertedRowMap != null) {
                        this.insertedRowMap.clear();
                        this.insertedRowMap = null;
                    }
                    if (this.posDeleteWriter == null) break block16;
                    try {
                        this.posDeleteWriter.close();
                        DeleteWriteResult result = this.posDeleteWriter.result();
                        BaseTaskWriter.this.completedDeleteFiles.addAll(result.deleteFiles());
                        BaseTaskWriter.this.referencedDataFiles.addAll(result.referencedDataFiles());
                    }
                    finally {
                        this.posDeleteWriter = null;
                    }
                }
                catch (IOException | RuntimeException e) {
                    BaseTaskWriter.this.setFailure(e);
                    throw e;
                }
            }
        }
    }
}

