/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Counter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    public static <E> CloseableIterator<E> empty() {
        return CloseableIterator.withClose(Collections.emptyIterator());
    }

    public static <E> CloseableIterator<E> withClose(final Iterator<E> iterator2) {
        if (iterator2 instanceof CloseableIterator) {
            return (CloseableIterator)iterator2;
        }
        return new CloseableIterator<E>(){

            @Override
            public void close() throws IOException {
                if (iterator2 instanceof Closeable) {
                    ((Closeable)((Object)iterator2)).close();
                }
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public E next() {
                return iterator2.next();
            }
        };
    }

    public static <I, O> CloseableIterator<O> transform(final CloseableIterator<I> iterator2, final Function<I, O> transform) {
        Preconditions.checkNotNull(transform, "Invalid transform: null");
        return new CloseableIterator<O>(){

            @Override
            public void close() throws IOException {
                iterator2.close();
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public O next() {
                return transform.apply(iterator2.next());
            }
        };
    }

    public static <T> CloseableIterator<T> count(final Counter counter, final CloseableIterator<T> iterator2) {
        return new CloseableIterator<T>(){

            @Override
            public void close() throws IOException {
                iterator2.close();
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                Object next = iterator2.next();
                counter.increment();
                return next;
            }
        };
    }
}

