/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;

public class ClosingIterator<T>
implements Iterator<T> {
    private final CloseableIterator<T> iterator;
    private boolean isClosed;

    public ClosingIterator(CloseableIterator<T> iterator2) {
        this.iterator = iterator2;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext && !this.isClosed) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public T next() {
        return (T)this.iterator.next();
    }

    private void close() {
        try {
            this.iterator.close();
            this.isClosed = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

