/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.ClusteredWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingEqualityDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.util.List;

public class ClusteredEqualityDeleteWriter<T>
extends ClusteredWriter<T, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final List<DeleteFile> deleteFiles;

    public ClusteredEqualityDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.deleteFiles = Lists.newArrayList();
    }

    @Override
    protected FileWriter<T, DeleteWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new RollingEqualityDeleteWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        Preconditions.checkArgument(!result.referencesDataFiles(), "Equality deletes cannot reference data files");
        this.deleteFiles.addAll(result.deleteFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles);
    }
}

