/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PartitioningWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Comparators;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Set;

abstract class ClusteredWriter<T, R>
implements PartitioningWriter<T, R> {
    private static final String NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE = "Incoming records violate the writer assumption that records are clustered by spec and by partition within each spec. Either cluster the incoming records or switch to fanout writers.\nEncountered records that belong to already closed files:\n";
    private final Set<Integer> completedSpecIds = Sets.newHashSet();
    private PartitionSpec currentSpec = null;
    private Comparator<StructLike> partitionComparator = null;
    private Set<StructLike> completedPartitions = null;
    private StructLike currentPartition = null;
    private FileWriter<T, R> currentWriter = null;
    private boolean closed = false;

    ClusteredWriter() {
    }

    protected abstract FileWriter<T, R> newWriter(PartitionSpec var1, StructLike var2);

    protected abstract void addResult(R var1);

    protected abstract R aggregatedResult();

    @Override
    public void write(T row, PartitionSpec spec, StructLike partition) {
        if (!spec.equals(this.currentSpec)) {
            if (this.currentSpec != null) {
                this.closeCurrentWriter();
                this.completedSpecIds.add(this.currentSpec.specId());
                this.completedPartitions.clear();
            }
            if (this.completedSpecIds.contains(spec.specId())) {
                String errorCtx = String.format("spec %s", spec);
                throw new IllegalStateException(NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE + errorCtx);
            }
            Types.StructType partitionType = spec.partitionType();
            this.currentSpec = spec;
            this.partitionComparator = Comparators.forType(partitionType);
            this.completedPartitions = StructLikeSet.create(partitionType);
            this.currentPartition = StructLikeUtil.copy(partition);
            this.currentWriter = this.newWriter(this.currentSpec, this.currentPartition);
        } else if (partition != this.currentPartition && this.partitionComparator.compare(partition, this.currentPartition) != 0) {
            this.closeCurrentWriter();
            this.completedPartitions.add(this.currentPartition);
            if (this.completedPartitions.contains(partition)) {
                String errorCtx = String.format("partition '%s' in spec %s", spec.partitionToPath(partition), spec);
                throw new IllegalStateException(NOT_CLUSTERED_ROWS_ERROR_MSG_TEMPLATE + errorCtx);
            }
            this.currentPartition = StructLikeUtil.copy(partition);
            this.currentWriter = this.newWriter(this.currentSpec, this.currentPartition);
        }
        this.currentWriter.write(row);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close current writer", e);
            }
            this.addResult(this.currentWriter.result());
            this.currentWriter = null;
        }
    }

    @Override
    public final R result() {
        Preconditions.checkState(this.closed, "Cannot get result from unclosed writer");
        return this.aggregatedResult();
    }
}

