/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.LocationProvider;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class OutputFileFactory {
    private final PartitionSpec defaultSpec;
    private final FileFormat format;
    private final LocationProvider locations;
    private final Supplier<FileIO> ioSupplier;
    private final EncryptionManager encryptionManager;
    private final int partitionId;
    private final long taskId;
    private final String operationId;
    private final AtomicInteger fileCount = new AtomicInteger(0);
    private final String suffix;

    private OutputFileFactory(PartitionSpec spec, FileFormat format, LocationProvider locations, Supplier<FileIO> ioSupplier, EncryptionManager encryptionManager, int partitionId, long taskId, String operationId, String suffix) {
        this.defaultSpec = spec;
        this.format = format;
        this.locations = locations;
        this.ioSupplier = ioSupplier;
        this.encryptionManager = encryptionManager;
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.operationId = operationId;
        this.suffix = suffix;
    }

    public static Builder builderFor(Table table, int partitionId, long taskId) {
        return new Builder(table, partitionId, taskId);
    }

    private String generateFilename() {
        return this.format.addExtension(String.format(Locale.ROOT, "%05d-%d-%s-%05d%s", this.partitionId, this.taskId, this.operationId, this.fileCount.incrementAndGet(), null != this.suffix ? "-" + this.suffix : ""));
    }

    public EncryptedOutputFile newOutputFile() {
        OutputFile file = this.ioSupplier.get().newOutputFile(this.locations.newDataLocation(this.generateFilename()));
        return this.encryptionManager.encrypt(file);
    }

    public EncryptedOutputFile newOutputFile(StructLike partition) {
        return this.newOutputFile(this.defaultSpec, partition);
    }

    public EncryptedOutputFile newOutputFile(PartitionSpec spec, StructLike partition) {
        String newDataLocation = this.locations.newDataLocation(spec, partition, this.generateFilename());
        OutputFile rawOutputFile = this.ioSupplier.get().newOutputFile(newDataLocation);
        return this.encryptionManager.encrypt(rawOutputFile);
    }

    public static class Builder {
        private final Table table;
        private final int partitionId;
        private final long taskId;
        private PartitionSpec defaultSpec;
        private String operationId;
        private FileFormat format;
        private String suffix;
        private Supplier<FileIO> ioSupplier;

        private Builder(Table table, int partitionId, long taskId) {
            this.table = table;
            this.partitionId = partitionId;
            this.taskId = taskId;
            this.defaultSpec = table.spec();
            this.operationId = UUID.randomUUID().toString();
            String formatAsString = table.properties().getOrDefault("write.format.default", "parquet");
            this.format = FileFormat.fromString(formatAsString);
            this.ioSupplier = table::io;
        }

        public Builder defaultSpec(PartitionSpec newDefaultSpec) {
            this.defaultSpec = newDefaultSpec;
            return this;
        }

        public Builder operationId(String newOperationId) {
            this.operationId = newOperationId;
            return this;
        }

        public Builder format(FileFormat newFormat) {
            this.format = newFormat;
            return this;
        }

        public Builder suffix(String newSuffix) {
            this.suffix = newSuffix;
            return this;
        }

        public Builder ioSupplier(Supplier<FileIO> newIoSupplier) {
            this.ioSupplier = newIoSupplier;
            return this;
        }

        public OutputFileFactory build() {
            LocationProvider locations = this.table.locationProvider();
            EncryptionManager encryption = this.table.encryption();
            return new OutputFileFactory(this.defaultSpec, this.format, locations, this.ioSupplier, encryption, this.partitionId, this.taskId, this.operationId, this.suffix);
        }
    }
}

