/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.BaseDVFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.DVFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDelete;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteIndex;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.PartitioningWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Function;

public class PartitioningDVWriter<T>
implements PartitioningWriter<PositionDelete<T>, DeleteWriteResult> {
    private final DVFileWriter writer;
    private DeleteWriteResult result;

    public PartitioningDVWriter(OutputFileFactory fileFactory, Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes) {
        this.writer = new BaseDVFileWriter(fileFactory, loadPreviousDeletes::apply);
    }

    @Override
    public void write(PositionDelete<T> row, PartitionSpec spec, StructLike partition) {
        this.writer.delete(row.path().toString(), row.pos(), spec, partition);
    }

    @Override
    public DeleteWriteResult result() {
        Preconditions.checkState(this.result != null, "Cannot get result from unclosed writer");
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            this.writer.close();
            this.result = this.writer.result();
        }
    }
}

