/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.CatalogUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopConfigurable;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.SerializableConfiguration;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.BulkDeletionFailureException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DelegateFileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileInfo;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.StorageCredential;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SupportsStorageCredentials;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvingFileIO
implements HadoopConfigurable,
DelegateFileIO,
SupportsStorageCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(ResolvingFileIO.class);
    private static final int BATCH_SIZE = 100000;
    private static final String FALLBACK_IMPL = "com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopFileIO";
    private static final String S3_FILE_IO_IMPL = "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.s3.S3FileIO";
    private static final String GCS_FILE_IO_IMPL = "com.dataiku.dss.shadelibgcp.org.apache.iceberg.gcp.gcs.GCSFileIO";
    private static final String ADLS_FILE_IO_IMPL = "com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO";
    private static final Map<String, String> SCHEME_TO_FILE_IO = ImmutableMap.of("s3", "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.s3.S3FileIO", "s3a", "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.s3.S3FileIO", "s3n", "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.s3.S3FileIO", "gs", "com.dataiku.dss.shadelibgcp.org.apache.iceberg.gcp.gcs.GCSFileIO", "abfs", "com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO", "abfss", "com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO", "wasb", "com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO", "wasbs", "com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSFileIO");
    private final Map<String, DelegateFileIO> ioInstances = Maps.newConcurrentMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final transient StackTraceElement[] createStack;
    private SerializableMap<String, String> properties;
    private SerializableSupplier<Configuration> hadoopConf;
    private List<StorageCredential> storageCredentials = Lists.newArrayList();

    public ResolvingFileIO() {
        this.createStack = Thread.currentThread().getStackTrace();
    }

    @Override
    public InputFile newInputFile(String location) {
        return this.io(location).newInputFile(location);
    }

    @Override
    public InputFile newInputFile(String location, long length) {
        return this.io(location).newInputFile(location, length);
    }

    @Override
    public OutputFile newOutputFile(String location) {
        return this.io(location).newOutputFile(location);
    }

    @Override
    public void deleteFile(String location) {
        this.io(location).deleteFile(location);
    }

    @Override
    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        Iterators.partition(pathsToDelete.iterator(), 100000).forEachRemaining(partitioned -> {
            Map<DelegateFileIO, List<String>> pathByFileIO = partitioned.stream().collect(Collectors.groupingBy(this::io));
            for (Map.Entry<DelegateFileIO, List<String>> entries : pathByFileIO.entrySet()) {
                DelegateFileIO io = entries.getKey();
                List<String> filePaths = entries.getValue();
                io.deleteFiles(filePaths);
            }
        });
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    @Override
    public void initialize(Map<String, String> newProperties) {
        this.close();
        this.properties = SerializableMap.copyOf(newProperties);
        this.isClosed.set(false);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            ArrayList<DelegateFileIO> instances = Lists.newArrayList();
            instances.addAll(this.ioInstances.values());
            this.ioInstances.clear();
            for (DelegateFileIO io : instances) {
                io.close();
            }
        }
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    public Configuration getConf() {
        return Optional.ofNullable(this.hadoopConf).map(Supplier::get).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    DelegateFileIO io(String location) {
        String impl = this.implFromLocation(location);
        DelegateFileIO io = this.ioInstances.get(impl);
        if (io != null) {
            if (io instanceof HadoopConfigurable && ((HadoopConfigurable)((Object)io)).getConf() == null) {
                DelegateFileIO delegateFileIO = io;
                synchronized (delegateFileIO) {
                    if (((HadoopConfigurable)((Object)io)).getConf() == null) {
                        ((HadoopConfigurable)((Object)io)).setConf(this.getConf());
                    }
                }
            }
            if (io instanceof SupportsStorageCredentials && !((SupportsStorageCredentials)((Object)io)).credentials().equals(this.storageCredentials)) {
                ((SupportsStorageCredentials)((Object)io)).setCredentials(this.storageCredentials);
            }
            return io;
        }
        return this.ioInstances.computeIfAbsent(impl, key -> {
            FileIO fileIO;
            Configuration conf = this.getConf();
            try {
                HashMap<String, String> props = Maps.newHashMap(this.properties);
                props.put("init-creation-stacktrace", "false");
                fileIO = CatalogUtil.loadFileIO(key, props, conf, this.storageCredentials);
            }
            catch (IllegalArgumentException e) {
                if (key.equals(FALLBACK_IMPL)) {
                    throw e;
                }
                LOG.warn("Failed to load FileIO implementation: {}, falling back to {}", new Object[]{key, FALLBACK_IMPL, e});
                try {
                    fileIO = CatalogUtil.loadFileIO(FALLBACK_IMPL, this.properties, conf, this.storageCredentials);
                }
                catch (IllegalArgumentException suppressed) {
                    LOG.warn("Failed to load FileIO implementation: {} (fallback)", (Object)FALLBACK_IMPL, (Object)suppressed);
                    e.addSuppressed(suppressed);
                    throw e;
                }
            }
            Preconditions.checkState(fileIO instanceof DelegateFileIO, "FileIO does not implement DelegateFileIO: " + fileIO.getClass().getName());
            return (DelegateFileIO)fileIO;
        });
    }

    @VisibleForTesting
    String implFromLocation(String location) {
        return SCHEME_TO_FILE_IO.getOrDefault(ResolvingFileIO.scheme(location), FALLBACK_IMPL);
    }

    public Class<?> ioClass(String location) {
        String fileIOClassName = this.implFromLocation(location);
        try {
            return Class.forName(fileIOClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Class %s not found : %s", fileIOClassName, e.getMessage());
        }
    }

    private static String scheme(String location) {
        int colonPos = location.indexOf(":");
        if (colonPos > 0) {
            return location.substring(0, colonPos);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed.get()) {
            this.close();
            if (null != this.createStack) {
                String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed ResolvingFileIO instance created by:\n\t{}", (Object)trace);
            }
        }
    }

    @Override
    public Iterable<FileInfo> listPrefix(String prefix) {
        return this.io(prefix).listPrefix(prefix);
    }

    @Override
    public void deletePrefix(String prefix) {
        this.io(prefix).deletePrefix(prefix);
    }

    @Override
    public void setCredentials(List<StorageCredential> credentials) {
        Preconditions.checkArgument(credentials != null, "Invalid storage credentials: null");
        this.storageCredentials = Lists.newArrayList(credentials);
    }

    @Override
    public List<StorageCredential> credentials() {
        return ImmutableList.copyOf(this.storageCredentials);
    }
}

