/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.util.List;

public class RollingDataWriter<T>
extends RollingFileWriter<T, DataWriter<T>, DataWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final List<DataFile> dataFiles;

    public RollingDataWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, PartitionSpec spec, StructLike partition) {
        super(fileFactory, io, targetFileSizeInBytes, spec, partition);
        this.writerFactory = writerFactory;
        this.dataFiles = Lists.newArrayList();
        this.openCurrentWriter();
    }

    @Override
    protected DataWriter<T> newWriter(EncryptedOutputFile file) {
        return this.writerFactory.newDataWriter(file, this.spec(), this.partition());
    }

    @Override
    protected void addResult(DataWriteResult result) {
        this.dataFiles.addAll(result.dataFiles());
    }

    @Override
    protected DataWriteResult aggregatedResult() {
        return new DataWriteResult(this.dataFiles);
    }
}

