/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.EqualityDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.util.List;

public class RollingEqualityDeleteWriter<T>
extends RollingFileWriter<T, EqualityDeleteWriter<T>, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final List<DeleteFile> deleteFiles;

    public RollingEqualityDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, PartitionSpec spec, StructLike partition) {
        super(fileFactory, io, targetFileSizeInBytes, spec, partition);
        this.writerFactory = writerFactory;
        this.deleteFiles = Lists.newArrayList();
        this.openCurrentWriter();
    }

    @Override
    protected EqualityDeleteWriter<T> newWriter(EncryptedOutputFile file) {
        return this.writerFactory.newEqualityDeleteWriter(file, this.spec(), this.partition());
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        Preconditions.checkArgument(!result.referencesDataFiles(), "Equality deletes cannot reference data files");
        this.deleteFiles.addAll(result.deleteFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles);
    }
}

