/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.metrics;

import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Timer;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class DefaultTimer
implements Timer {
    private final TimeUnit timeUnit;
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();

    public DefaultTimer(TimeUnit timeUnit) {
        Preconditions.checkArgument(null != timeUnit, "Invalid time unit: null");
        this.timeUnit = timeUnit;
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public Duration totalDuration() {
        return Duration.ofNanos(this.totalTime.longValue());
    }

    @Override
    public Timer.Timed start() {
        return new DefaultTimed(this, this.timeUnit);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        Preconditions.checkArgument(amount >= 0L, "Cannot record %s %s: must be >= 0", amount, (Object)unit);
        this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
        this.count.increment();
    }

    @Override
    public <T> T time(Supplier<T> supplier) {
        try (Timer.Timed ignore = this.start();){
            T t2 = supplier.get();
            return t2;
        }
    }

    @Override
    public <T> T timeCallable(Callable<T> callable) throws Exception {
        try (Timer.Timed ignore = this.start();){
            T t2 = callable.call();
            return t2;
        }
    }

    @Override
    public void time(Runnable runnable) {
        try (Timer.Timed ignore = this.start();){
            runnable.run();
        }
    }

    @Override
    public TimeUnit unit() {
        return this.timeUnit;
    }

    public String toString() {
        return MoreObjects.toStringHelper(DefaultTimer.class).add("duration", this.totalDuration()).add("count", this.count).add("timeUnit", (Object)this.timeUnit).toString();
    }

    private static class DefaultTimed
    implements Timer.Timed {
        private final Timer timer;
        private final TimeUnit defaultTimeUnit;
        private final AtomicReference<Stopwatch> stopwatchRef = new AtomicReference();

        private DefaultTimed(Timer timer, TimeUnit defaultTimeUnit) {
            this.timer = timer;
            this.defaultTimeUnit = defaultTimeUnit;
            this.stopwatchRef.compareAndSet(null, Stopwatch.createStarted());
        }

        @Override
        public void stop() {
            Stopwatch stopwatch = this.stopwatchRef.getAndSet(null);
            Preconditions.checkState(null != stopwatch, "stop() called multiple times");
            this.timer.record(stopwatch.stop().elapsed(this.defaultTimeUnit), this.defaultTimeUnit);
        }
    }
}

