/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReport;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ErrorHandlers;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ReportMetricsRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RESTMetricsReporter
implements MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(RESTMetricsReporter.class);
    private static final ExecutorService METRICS_EXECUTOR = ThreadPools.newExitingWorkerPool("rest-metrics-reporter", 1);
    private final RESTClient client;
    private final String metricsEndpoint;
    private final Supplier<Map<String, String>> headers;

    RESTMetricsReporter(RESTClient client, String metricsEndpoint, Supplier<Map<String, String>> headers) {
        this.client = client;
        this.metricsEndpoint = metricsEndpoint;
        this.headers = headers;
    }

    @Override
    public void report(MetricsReport report) {
        if (null == report) {
            LOG.warn("Received invalid metrics report: null");
            return;
        }
        Tasks.range(1).executeWith(METRICS_EXECUTOR).suppressFailureWhenFinished().onFailure((item, exception) -> LOG.warn("Failed to report metrics to REST endpoint {}", (Object)this.metricsEndpoint, (Object)exception)).run(item -> this.client.post(this.metricsEndpoint, (RESTRequest)ReportMetricsRequest.of(report), null, this.headers, ErrorHandlers.defaultErrorHandler()));
    }
}

