/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials;

import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.Credential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Credential", generator="Immutables")
@Immutable
public final class ImmutableCredential
implements Credential {
    private final String prefix;
    private final Map<String, String> config;

    private ImmutableCredential(String prefix, Map<String, String> config) {
        this.prefix = prefix;
        this.config = config;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public Map<String, String> config() {
        return this.config;
    }

    public final ImmutableCredential withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return ImmutableCredential.validate(new ImmutableCredential(newValue, this.config));
    }

    public final ImmutableCredential withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableCredential.createUnmodifiableMap(true, false, entries);
        return ImmutableCredential.validate(new ImmutableCredential(this.prefix, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCredential && this.equalsByValue((ImmutableCredential)another);
    }

    private boolean equalsByValue(ImmutableCredential another) {
        return this.prefix.equals(another.prefix) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.prefix.hashCode();
        h2 += (h2 << 5) + this.config.hashCode();
        return h2;
    }

    public String toString() {
        return "Credential{prefix=" + this.prefix + ", config=" + String.valueOf(this.config) + "}";
    }

    private static ImmutableCredential validate(ImmutableCredential instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableCredential copyOf(Credential instance) {
        if (instance instanceof ImmutableCredential) {
            return (ImmutableCredential)instance;
        }
        return ImmutableCredential.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Credential", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREFIX = 1L;
        private long initBits = 1L;
        @Nullable
        private String prefix;
        private Map<String, String> config = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Credential instance) {
            Objects.requireNonNull(instance, "instance");
            this.prefix(instance.prefix());
            this.putAllConfig(instance.config());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, value == null ? "config value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "config value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "config value for key: " + k : null));
            }
            return this;
        }

        public ImmutableCredential build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCredential.validate(new ImmutableCredential(this.prefix, ImmutableCredential.createUnmodifiableMap(false, false, this.config)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefix");
            }
            return "Cannot build Credential, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

