/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.FetchScanTasksRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;

public class FetchScanTasksRequestParser {
    private static final String PLAN_TASK = "plan-task";

    private FetchScanTasksRequestParser() {
    }

    public static String toJson(FetchScanTasksRequest request) {
        return FetchScanTasksRequestParser.toJson(request, false);
    }

    public static String toJson(FetchScanTasksRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> FetchScanTasksRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(FetchScanTasksRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid fetchScanTasks request: null");
        gen.writeStartObject();
        gen.writeStringField(PLAN_TASK, request.planTask());
        gen.writeEndObject();
    }

    public static FetchScanTasksRequest fromJson(String json) {
        return JsonUtil.parse(json, FetchScanTasksRequestParser::fromJson);
    }

    public static FetchScanTasksRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Invalid fetchScanTasks request: null");
        String planTask = JsonUtil.getString(PLAN_TASK, json);
        return new FetchScanTasksRequest(planTask);
    }
}

