/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateViewRequest", generator="Immutables")
@Immutable
public final class ImmutableCreateViewRequest
implements CreateViewRequest {
    private final String name;
    @Nullable
    private final String location;
    private final Schema schema;
    private final ViewVersion viewVersion;
    private final Map<String, String> properties;

    private ImmutableCreateViewRequest(String name, @Nullable String location, Schema schema, ViewVersion viewVersion, Map<String, String> properties) {
        this.name = name;
        this.location = location;
        this.schema = schema;
        this.viewVersion = viewVersion;
        this.properties = properties;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String location() {
        return this.location;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public ViewVersion viewVersion() {
        return this.viewVersion;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public final ImmutableCreateViewRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateViewRequest(newValue, this.location, this.schema, this.viewVersion, this.properties);
    }

    public final ImmutableCreateViewRequest withLocation(@Nullable String value) {
        if (Objects.equals(this.location, value)) {
            return this;
        }
        return new ImmutableCreateViewRequest(this.name, value, this.schema, this.viewVersion, this.properties);
    }

    public final ImmutableCreateViewRequest withSchema(Schema value) {
        if (this.schema == value) {
            return this;
        }
        Schema newValue = Objects.requireNonNull(value, "schema");
        return new ImmutableCreateViewRequest(this.name, this.location, newValue, this.viewVersion, this.properties);
    }

    public final ImmutableCreateViewRequest withViewVersion(ViewVersion value) {
        if (this.viewVersion == value) {
            return this;
        }
        ViewVersion newValue = Objects.requireNonNull(value, "viewVersion");
        return new ImmutableCreateViewRequest(this.name, this.location, this.schema, newValue, this.properties);
    }

    public final ImmutableCreateViewRequest withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableCreateViewRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableCreateViewRequest(this.name, this.location, this.schema, this.viewVersion, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateViewRequest && this.equalsByValue((ImmutableCreateViewRequest)another);
    }

    private boolean equalsByValue(ImmutableCreateViewRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.location, another.location) && this.schema.equals(another.schema) && this.viewVersion.equals(another.viewVersion) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.location);
        h2 += (h2 << 5) + this.schema.hashCode();
        h2 += (h2 << 5) + this.viewVersion.hashCode();
        h2 += (h2 << 5) + this.properties.hashCode();
        return h2;
    }

    public String toString() {
        return "CreateViewRequest{name=" + this.name + ", location=" + this.location + ", schema=" + String.valueOf(this.schema) + ", viewVersion=" + String.valueOf(this.viewVersion) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public static ImmutableCreateViewRequest copyOf(CreateViewRequest instance) {
        if (instance instanceof ImmutableCreateViewRequest) {
            return (ImmutableCreateViewRequest)instance;
        }
        return ImmutableCreateViewRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CreateViewRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SCHEMA = 2L;
        private static final long INIT_BIT_VIEW_VERSION = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private String location;
        @Nullable
        private Schema schema;
        @Nullable
        private ViewVersion viewVersion;
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateViewRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            String locationValue = instance.location();
            if (locationValue != null) {
                this.location(locationValue);
            }
            this.schema(instance.schema());
            this.viewVersion(instance.viewVersion());
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder location(@Nullable String location) {
            this.location = location;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schema(Schema schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder viewVersion(ViewVersion viewVersion) {
            this.viewVersion = Objects.requireNonNull(viewVersion, "viewVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "properties value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "properties value for key: " + k : null));
            }
            return this;
        }

        public ImmutableCreateViewRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateViewRequest(this.name, this.location, this.schema, this.viewVersion, ImmutableCreateViewRequest.createUnmodifiableMap(false, false, this.properties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("schema");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("viewVersion");
            }
            return "Cannot build CreateViewRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

