/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;

public class RenameTableRequest
implements RESTRequest {
    private TableIdentifier source;
    private TableIdentifier destination;

    public RenameTableRequest() {
    }

    private RenameTableRequest(TableIdentifier source, TableIdentifier destination) {
        this.source = source;
        this.destination = destination;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.source != null, "Invalid source table: null");
        Preconditions.checkArgument(this.destination != null, "Invalid destination table: null");
    }

    public TableIdentifier source() {
        return this.source;
    }

    public TableIdentifier destination() {
        return this.destination;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("destination", this.destination).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TableIdentifier source;
        private TableIdentifier destination;

        private Builder() {
        }

        public Builder withSource(TableIdentifier sourceTable) {
            Preconditions.checkNotNull(sourceTable, "Invalid source table identifier: null");
            this.source = sourceTable;
            return this;
        }

        public Builder withDestination(TableIdentifier destinationTable) {
            Preconditions.checkNotNull(destinationTable, "Invalid destination table identifier: null");
            this.destination = destinationTable;
            return this;
        }

        public RenameTableRequest build() {
            return new RenameTableRequest(this.source, this.destination);
        }
    }
}

