/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.Credential;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.credentials.CredentialParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ImmutableLoadCredentialsResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;

public class LoadCredentialsResponseParser {
    private static final String STORAGE_CREDENTIALS = "storage-credentials";

    private LoadCredentialsResponseParser() {
    }

    public static String toJson(LoadCredentialsResponse response) {
        return LoadCredentialsResponseParser.toJson(response, false);
    }

    public static String toJson(LoadCredentialsResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> LoadCredentialsResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(LoadCredentialsResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid load credentials response: null");
        gen.writeStartObject();
        gen.writeArrayFieldStart(STORAGE_CREDENTIALS);
        for (Credential credential : response.credentials()) {
            CredentialParser.toJson(credential, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static LoadCredentialsResponse fromJson(String json) {
        return JsonUtil.parse(json, LoadCredentialsResponseParser::fromJson);
    }

    public static LoadCredentialsResponse fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse load credentials response from null object");
        JsonNode credentials = JsonUtil.get(STORAGE_CREDENTIALS, json);
        Preconditions.checkArgument(credentials.isArray(), "Cannot parse credentials from non-array: %s", (Object)credentials);
        ImmutableLoadCredentialsResponse.Builder builder = ImmutableLoadCredentialsResponse.builder();
        for (JsonNode credential : credentials) {
            builder.addCredentials(CredentialParser.fromJson(credential));
        }
        return builder.build();
    }
}

