/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Dates;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.SerializationProxies;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TimeTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Timestamps;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TransformUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.io.ObjectStreamException;
import java.time.temporal.ChronoUnit;

public class Months<T>
extends TimeTransform<T> {
    private static final Months<?> INSTANCE = new Months();

    static <T> Months<T> get() {
        return INSTANCE;
    }

    @Override
    protected ChronoUnit granularity() {
        return ChronoUnit.MONTHS;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        return Months.fromSourceType(type, Dates.MONTH, Timestamps.MICROS_TO_MONTH, Timestamps.NANOS_TO_MONTH);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public String toHumanString(Type alwaysInt, Integer value) {
        return value != null ? TransformUtil.humanMonth(value) : "null";
    }

    public String toString() {
        return "month";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.MonthsTransformProxy.get();
    }
}

