/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Bucket;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Days;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Hours;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Identity;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Months;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Truncate;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.UnknownTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.VoidTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Years;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Transforms {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)\\]");

    private Transforms() {
    }

    public static Transform<?, ?> fromString(String transform) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transform);
        if (widthMatcher.matches()) {
            String name = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(parsedWidth);
            }
            if (name.equalsIgnoreCase("bucket")) {
                return Bucket.get(parsedWidth);
            }
        }
        if (transform.equalsIgnoreCase("identity")) {
            return Identity.get();
        }
        if (transform.equalsIgnoreCase("year")) {
            return Years.get();
        }
        if (transform.equalsIgnoreCase("month")) {
            return Months.get();
        }
        if (transform.equalsIgnoreCase("day")) {
            return Days.get();
        }
        if (transform.equalsIgnoreCase("hour")) {
            return Hours.get();
        }
        if (transform.equalsIgnoreCase("void")) {
            return VoidTransform.get();
        }
        return new UnknownTransform(transform);
    }

    @Deprecated
    public static Transform<?, ?> fromString(Type type, String transform) {
        String lowerTransform;
        Matcher widthMatcher = HAS_WIDTH.matcher(transform);
        if (widthMatcher.matches()) {
            String name = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(type, parsedWidth);
            }
            if (name.equalsIgnoreCase("bucket")) {
                return Bucket.get(type, parsedWidth);
            }
        }
        switch (lowerTransform = transform.toLowerCase(Locale.ENGLISH)) {
            case "identity": {
                return Identity.get(type);
            }
            case "year": {
                return Years.get().toEnum(type);
            }
            case "month": {
                return Months.get().toEnum(type);
            }
            case "day": {
                return Days.get().toEnum(type);
            }
            case "hour": {
                return Hours.get().toEnum(type);
            }
            case "void": {
                return VoidTransform.get();
            }
        }
        return new UnknownTransform(transform);
    }

    @Deprecated
    public static <T> Transform<T, T> identity(Type type) {
        return Identity.get(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> year(Type type) {
        return Years.get().toEnum(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> month(Type type) {
        return Months.get().toEnum(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> day(Type type) {
        return Days.get().toEnum(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> hour(Type type) {
        return Hours.get().toEnum(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> bucket(Type type, int numBuckets) {
        return Bucket.get(type, numBuckets);
    }

    @Deprecated
    public static <T> Transform<T, T> truncate(Type type, int width) {
        return Truncate.get(type, width);
    }

    public static <T> Transform<T, T> identity() {
        return Identity.get();
    }

    public static <T> Transform<T, Integer> year() {
        return Years.get();
    }

    public static <T> Transform<T, Integer> month() {
        return Months.get();
    }

    public static <T> Transform<T, Integer> day() {
        return Days.get();
    }

    public static <T> Transform<T, Integer> hour() {
        return Hours.get();
    }

    public static <T> Transform<T, Integer> bucket(int numBuckets) {
        return Bucket.get(numBuckets);
    }

    public static <T> Transform<T, T> truncate(int width) {
        return Truncate.get(width);
    }

    public static <T> Transform<T, Void> alwaysNull() {
        return VoidTransform.get();
    }
}

