/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Streams;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class CharSequenceSet
implements Set<CharSequence>,
Serializable {
    private static final ThreadLocal<CharSequenceWrapper> WRAPPERS = ThreadLocal.withInitial(() -> CharSequenceWrapper.wrap(null));
    private final Set<CharSequenceWrapper> wrapperSet;

    public static CharSequenceSet of(Iterable<CharSequence> charSequences) {
        return new CharSequenceSet(charSequences);
    }

    public static CharSequenceSet empty() {
        return new CharSequenceSet(ImmutableList.of());
    }

    private CharSequenceSet(Iterable<CharSequence> charSequences) {
        this.wrapperSet = Sets.newHashSet(Iterables.transform(charSequences, CharSequenceWrapper::wrap));
    }

    @Override
    public int size() {
        return this.wrapperSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperSet.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof CharSequence) {
            CharSequenceWrapper wrapper = WRAPPERS.get();
            boolean result = this.wrapperSet.contains(wrapper.set((CharSequence)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Iterators.transform(this.wrapperSet.iterator(), CharSequenceWrapper::get);
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), CharSequence.class);
    }

    @Override
    public <T> T[] toArray(T[] destArray) {
        int size = this.wrapperSet.size();
        if (destArray.length < size) {
            return this.toArray();
        }
        Iterator<CharSequence> iter = this.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            destArray[ind] = iter.next();
            ++ind;
        }
        if (destArray.length > size) {
            destArray[size] = null;
        }
        return destArray;
    }

    @Override
    public boolean add(CharSequence charSequence) {
        return this.wrapperSet.add(CharSequenceWrapper.wrap(charSequence));
    }

    @Override
    public boolean remove(Object obj) {
        if (obj instanceof CharSequence) {
            CharSequenceWrapper wrapper = WRAPPERS.get();
            boolean result = this.wrapperSet.remove(wrapper.set((CharSequence)obj));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.all(objects, this::contains);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends CharSequence> charSequences) {
        if (charSequences != null) {
            return Iterables.addAll(this.wrapperSet, Iterables.transform(charSequences, CharSequenceWrapper::wrap));
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects != null) {
            Set toRetain = objects.stream().filter(CharSequence.class::isInstance).map(CharSequence.class::cast).map(CharSequenceWrapper::wrap).collect(Collectors.toSet());
            return Iterables.retainAll(this.wrapperSet, toRetain);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects != null) {
            return objects.stream().filter(this::remove).count() != 0L;
        }
        return false;
    }

    @Override
    public void clear() {
        this.wrapperSet.clear();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (this.size() != that.size()) {
            return false;
        }
        try {
            return this.containsAll(that);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.wrapperSet.stream().mapToInt(CharSequenceWrapper::hashCode).sum();
    }

    public String toString() {
        return Streams.stream(this.iterator()).collect(Collectors.joining("CharSequenceSet({", ", ", "})"));
    }
}

