/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.Metrics;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteTablePathUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Conversions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContentFileUtil {
    private static final int PATH_ID = MetadataColumns.DELETE_FILE_PATH.fieldId();
    private static final Type PATH_TYPE = MetadataColumns.DELETE_FILE_PATH.type();

    private ContentFileUtil() {
    }

    public static <F extends ContentFile<K>, K> K copy(F file, boolean withStats, Set<Integer> requestedColumnIds) {
        if (withStats) {
            return requestedColumnIds != null ? file.copyWithStats(requestedColumnIds) : file.copy();
        }
        return file.copyWithoutStats();
    }

    public static CharSequence referencedDataFile(DeleteFile deleteFile) {
        ByteBuffer upperPathBound;
        ByteBuffer lowerPathBound;
        if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
            return null;
        }
        if (deleteFile.referencedDataFile() != null) {
            return deleteFile.referencedDataFile();
        }
        Map<Integer, ByteBuffer> lowerBounds = deleteFile.lowerBounds();
        ByteBuffer byteBuffer = lowerPathBound = lowerBounds != null ? lowerBounds.get(PATH_ID) : null;
        if (lowerPathBound == null) {
            return null;
        }
        Map<Integer, ByteBuffer> upperBounds = deleteFile.upperBounds();
        ByteBuffer byteBuffer2 = upperPathBound = upperBounds != null ? upperBounds.get(PATH_ID) : null;
        if (upperPathBound == null) {
            return null;
        }
        if (lowerPathBound.equals(upperPathBound)) {
            return (CharSequence)Conversions.fromByteBuffer(PATH_TYPE, lowerPathBound);
        }
        return null;
    }

    public static Metrics replacePathBounds(DeleteFile deleteFile, String sourcePrefix, String targetPrefix) {
        ByteBuffer upperPathBound;
        ByteBuffer lowerPathBound;
        Preconditions.checkArgument(deleteFile.content() == FileContent.POSITION_DELETES, "Only position delete files supported");
        Map<Integer, ByteBuffer> lowerBounds = deleteFile.lowerBounds();
        ByteBuffer byteBuffer = lowerPathBound = lowerBounds != null ? lowerBounds.get(PATH_ID) : null;
        if (lowerPathBound == null) {
            return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
        }
        Map<Integer, ByteBuffer> upperBounds = deleteFile.upperBounds();
        ByteBuffer byteBuffer2 = upperPathBound = upperBounds != null ? upperBounds.get(PATH_ID) : null;
        if (upperPathBound == null) {
            return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
        }
        if (lowerPathBound.equals(upperPathBound)) {
            CharBuffer path = (CharBuffer)Conversions.fromByteBuffer(PATH_TYPE, lowerPathBound);
            CharBuffer newPath = CharBuffer.wrap(RewriteTablePathUtil.newPath(path.toString(), sourcePrefix, targetPrefix));
            ByteBuffer newBytes = Conversions.toByteBuffer(PATH_TYPE, (Object)newPath);
            return ContentFileUtil.metricsWithPathBounds(deleteFile, newBytes);
        }
        return ContentFileUtil.metricsWithoutPathBounds(deleteFile);
    }

    public static String referencedDataFileLocation(DeleteFile deleteFile) {
        CharSequence location = ContentFileUtil.referencedDataFile(deleteFile);
        return location != null ? location.toString() : null;
    }

    public static boolean isFileScoped(DeleteFile deleteFile) {
        return ContentFileUtil.referencedDataFile(deleteFile) != null;
    }

    public static boolean isDV(DeleteFile deleteFile) {
        return deleteFile.format() == FileFormat.PUFFIN;
    }

    public static boolean containsSingleDV(Iterable<DeleteFile> deleteFiles) {
        return Iterables.size(deleteFiles) == 1 && Iterables.all(deleteFiles, ContentFileUtil::isDV);
    }

    public static String dvDesc(DeleteFile deleteFile) {
        return String.format("DV{location=%s, offset=%s, length=%s, referencedDataFile=%s}", deleteFile.location(), deleteFile.contentOffset(), deleteFile.contentSizeInBytes(), deleteFile.referencedDataFile());
    }

    private static Metrics metricsWithoutPathBounds(DeleteFile file) {
        HashMap<Integer, ByteBuffer> upperBounds;
        HashMap<Integer, ByteBuffer> lowerBounds = file.lowerBounds() == null ? null : Maps.newHashMap(file.lowerBounds());
        HashMap<Integer, ByteBuffer> hashMap = upperBounds = file.upperBounds() == null ? null : Maps.newHashMap(file.upperBounds());
        if (lowerBounds != null) {
            lowerBounds.remove(PATH_ID);
        }
        if (upperBounds != null) {
            upperBounds.remove(PATH_ID);
        }
        return new Metrics(file.recordCount(), file.columnSizes(), file.valueCounts(), file.nullValueCounts(), file.nanValueCounts(), lowerBounds == null ? null : Collections.unmodifiableMap(lowerBounds), upperBounds == null ? null : Collections.unmodifiableMap(upperBounds));
    }

    private static Metrics metricsWithPathBounds(DeleteFile file, ByteBuffer bound) {
        HashMap<Integer, ByteBuffer> upperBounds;
        HashMap<Integer, ByteBuffer> lowerBounds = file.lowerBounds() == null ? null : Maps.newHashMap(file.lowerBounds());
        HashMap<Integer, ByteBuffer> hashMap = upperBounds = file.upperBounds() == null ? null : Maps.newHashMap(file.upperBounds());
        if (lowerBounds != null) {
            lowerBounds.put(PATH_ID, bound);
        }
        if (upperBounds != null) {
            upperBounds.put(PATH_ID, bound);
        }
        return new Metrics(file.recordCount(), file.columnSizes(), file.valueCounts(), file.nullValueCounts(), file.nanValueCounts(), lowerBounds == null ? null : Collections.unmodifiableMap(lowerBounds), upperBounds == null ? null : Collections.unmodifiableMap(upperBounds));
    }
}

