/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.WrapperSet;
import java.util.Objects;

public class DeleteFileSet
extends WrapperSet<DeleteFile> {
    private static final ThreadLocal<DeleteFileWrapper> WRAPPERS = ThreadLocal.withInitial(() -> DeleteFileWrapper.wrap(null));

    private DeleteFileSet() {
    }

    private DeleteFileSet(Iterable<WrapperSet.Wrapper<DeleteFile>> wrappers) {
        super(wrappers);
    }

    public static DeleteFileSet create() {
        return new DeleteFileSet();
    }

    public static DeleteFileSet of(Iterable<? extends DeleteFile> iterable) {
        return new DeleteFileSet(Iterables.transform(iterable, obj -> {
            Preconditions.checkNotNull(obj, "Invalid object: null");
            return DeleteFileWrapper.wrap(obj);
        }));
    }

    @Override
    protected WrapperSet.Wrapper<DeleteFile> wrapper() {
        return WRAPPERS.get();
    }

    @Override
    protected WrapperSet.Wrapper<DeleteFile> wrap(DeleteFile deleteFile) {
        return DeleteFileWrapper.wrap(deleteFile);
    }

    @Override
    protected Class<DeleteFile> elementClass() {
        return DeleteFile.class;
    }

    private static class DeleteFileWrapper
    implements WrapperSet.Wrapper<DeleteFile> {
        private DeleteFile file;

        private DeleteFileWrapper(DeleteFile file) {
            this.file = file;
        }

        private static DeleteFileWrapper wrap(DeleteFile deleteFile) {
            return new DeleteFileWrapper(deleteFile);
        }

        @Override
        public DeleteFile get() {
            return this.file;
        }

        @Override
        public WrapperSet.Wrapper<DeleteFile> set(DeleteFile deleteFile) {
            this.file = deleteFile;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteFileWrapper)) {
                return false;
            }
            DeleteFileWrapper that = (DeleteFileWrapper)o;
            return Objects.equals(this.file.location(), that.file.location()) && Objects.equals(this.file.contentOffset(), that.file.contentOffset()) && Objects.equals(this.file.contentSizeInBytes(), that.file.contentSizeInBytes());
        }

        public int hashCode() {
            return Objects.hash(this.file.location(), this.file.contentOffset(), this.file.contentSizeInBytes());
        }

        public String toString() {
            return this.file.location();
        }
    }
}

