/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HiddenPathFilter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileInfo;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SupportsPrefixOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class FileSystemWalker {
    private FileSystemWalker() {
    }

    public static void listDirRecursivelyWithFileIO(SupportsPrefixOperations io, String dir, Map<Integer, PartitionSpec> specs, Predicate<FileInfo> filter, Consumer<String> fileConsumer) {
        PathFilter pathFilter = PartitionAwareHiddenPathFilter.forSpecs(specs);
        Object listPath = dir;
        if (!dir.endsWith("/")) {
            listPath = dir + "/";
        }
        Iterable<FileInfo> files = io.listPrefix((String)listPath);
        for (FileInfo file : files) {
            Path path = new Path(file.location());
            if (FileSystemWalker.isHiddenPath(dir, path, pathFilter) || !filter.test(file)) continue;
            fileConsumer.accept(file.location());
        }
    }

    public static void listDirRecursivelyWithHadoop(String dir, Map<Integer, PartitionSpec> specs, Predicate<FileStatus> filter, Configuration conf, int maxDepth, int maxDirectSubDirs, Consumer<String> directoryConsumer, Consumer<String> fileConsumer) {
        PathFilter pathFilter = PartitionAwareHiddenPathFilter.forSpecs(specs);
        if (maxDepth <= 0) {
            directoryConsumer.accept(dir);
            return;
        }
        try {
            Path path = new Path(dir);
            FileSystem fs = path.getFileSystem(conf);
            ArrayList<String> subDirs = Lists.newArrayList();
            for (FileStatus file : fs.listStatus(path, pathFilter)) {
                if (file.isDirectory()) {
                    subDirs.add(file.getPath().toString());
                    continue;
                }
                if (!file.isFile() || !filter.test(file)) continue;
                fileConsumer.accept(file.getPath().toString());
            }
            if (subDirs.size() > maxDirectSubDirs) {
                subDirs.forEach(directoryConsumer);
                return;
            }
            for (String subDir : subDirs) {
                FileSystemWalker.listDirRecursivelyWithHadoop(subDir, specs, filter, conf, maxDepth - 1, maxDirectSubDirs, directoryConsumer, fileConsumer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isHiddenPath(String baseDir, Path path, PathFilter pathFilter) {
        boolean isHiddenPath = false;
        Path currentPath = path;
        while (currentPath.getParent().toString().contains(baseDir)) {
            if (!pathFilter.accept(currentPath)) {
                isHiddenPath = true;
                break;
            }
            currentPath = currentPath.getParent();
        }
        return isHiddenPath;
    }

    private static class PartitionAwareHiddenPathFilter
    implements PathFilter,
    Serializable {
        private final Set<String> hiddenPathPartitionNames;

        private PartitionAwareHiddenPathFilter(Set<String> hiddenPathPartitionNames) {
            this.hiddenPathPartitionNames = hiddenPathPartitionNames;
        }

        public boolean accept(Path path) {
            return this.isHiddenPartitionPath(path) || HiddenPathFilter.get().accept(path);
        }

        private boolean isHiddenPartitionPath(Path path) {
            return this.hiddenPathPartitionNames.stream().anyMatch(path.getName()::startsWith);
        }

        public static PathFilter forSpecs(Map<Integer, PartitionSpec> specs) {
            if (specs == null) {
                return HiddenPathFilter.get();
            }
            Set<String> partitionNames = specs.values().stream().map(PartitionSpec::fields).flatMap(Collection::stream).filter(field -> field.name().startsWith("_") || field.name().startsWith(".")).map(field -> field.name() + "=").collect(Collectors.toSet());
            if (partitionNames.isEmpty()) {
                return HiddenPathFilter.get();
            }
            return new PartitionAwareHiddenPathFilter(partitionNames);
        }
    }
}

