/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.variants;

import com.dataiku.dss.shadelib.org.apache.iceberg.variants.PhysicalType;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantValue;
import java.util.Objects;

public interface VariantObject
extends VariantValue {
    public VariantValue get(String var1);

    public Iterable<String> fieldNames();

    public int numFields();

    @Override
    default public PhysicalType type() {
        return PhysicalType.OBJECT;
    }

    @Override
    default public VariantObject asObject() {
        return this;
    }

    public static String asString(VariantObject object) {
        StringBuilder builder = new StringBuilder();
        builder.append("VariantObject(fields={");
        boolean first = true;
        for (String field : object.fieldNames()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(field).append(": ").append(object.get(field));
        }
        builder.append("})");
        return builder.toString();
    }

    public static int hash(VariantObject self) {
        int hash = 17;
        for (String field : self.fieldNames()) {
            hash = 59 * hash + field.hashCode();
            hash = 59 * hash + self.get(field).hashCode();
        }
        return hash;
    }

    public static boolean equals(VariantObject self, Object obj) {
        if (self == obj) {
            return true;
        }
        if (!(obj instanceof VariantObject)) {
            return false;
        }
        VariantObject other = (VariantObject)obj;
        if (self.numFields() != other.numFields()) {
            return false;
        }
        for (String field : self.fieldNames()) {
            if (Objects.equals(self.get(field), other.get(field))) continue;
            return false;
        }
        return true;
    }
}

