/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.variants;

import com.dataiku.dss.shadelib.org.apache.iceberg.variants.BasicType;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.PhysicalType;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.SerializedArray;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.SerializedObject;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.SerializedPrimitive;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.SerializedShortString;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantArray;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantObject;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantPrimitive;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantUtil;
import java.nio.ByteBuffer;

public interface VariantValue {
    public PhysicalType type();

    public int sizeInBytes();

    public int writeTo(ByteBuffer var1, int var2);

    default public VariantPrimitive<?> asPrimitive() {
        throw new IllegalArgumentException("Not a primitive: " + String.valueOf(this));
    }

    default public VariantObject asObject() {
        throw new IllegalArgumentException("Not an object: " + String.valueOf(this));
    }

    default public VariantArray asArray() {
        throw new IllegalArgumentException("Not an array: " + String.valueOf(this));
    }

    public static VariantValue from(VariantMetadata metadata, ByteBuffer value) {
        int header = VariantUtil.readByte(value, 0);
        BasicType basicType = VariantUtil.basicType(header);
        switch (basicType) {
            case PRIMITIVE: {
                return SerializedPrimitive.from(value, header);
            }
            case SHORT_STRING: {
                return SerializedShortString.from(value, header);
            }
            case OBJECT: {
                return SerializedObject.from(metadata, value, header);
            }
            case ARRAY: {
                return SerializedArray.from(metadata, value, header);
            }
        }
        throw new UnsupportedOperationException("Unsupported basic type: " + String.valueOf((Object)basicType));
    }
}

