/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.view;

import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitFailedException;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewOperations;

class SetViewLocation
implements UpdateLocation {
    private final ViewOperations ops;
    private String newLocation = null;

    SetViewLocation(ViewOperations ops) {
        this.ops = ops;
    }

    @Override
    public String apply() {
        Preconditions.checkState(null != this.newLocation, "Invalid view location: null");
        return this.newLocation;
    }

    @Override
    public void commit() {
        ViewMetadata base = this.ops.refresh();
        Tasks.foreach(this.ops).retry(PropertyUtil.propertyAsInt(base.properties(), "commit.retry.num-retries", 4)).exponentialBackoff(PropertyUtil.propertyAsInt(base.properties(), "commit.retry.min-wait-ms", 100), PropertyUtil.propertyAsInt(base.properties(), "commit.retry.max-wait-ms", 60000), PropertyUtil.propertyAsInt(base.properties(), "commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(base, ViewMetadata.buildFrom(base).setLocation(this.apply()).build()));
    }

    @Override
    public UpdateLocation setLocation(String location) {
        this.newLocation = location;
        return this;
    }
}

