/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.view;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableViewHistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableViewVersion;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.SQLViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewHistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable(builder=false)
@Value.Style(allParameters=true, visibilityString="PACKAGE")
public interface ViewMetadata
extends Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(ViewMetadata.class);
    public static final int SUPPORTED_VIEW_FORMAT_VERSION = 1;
    public static final int DEFAULT_VIEW_FORMAT_VERSION = 1;

    public String uuid();

    public int formatVersion();

    public String location();

    default public Integer currentSchemaId() {
        int currentSchemaId = this.currentVersion().schemaId();
        Preconditions.checkArgument(this.schemasById().containsKey(currentSchemaId), "Cannot find current schema with id %s in schemas: %s", currentSchemaId, this.schemasById().keySet());
        return currentSchemaId;
    }

    public List<Schema> schemas();

    public int currentVersionId();

    public List<ViewVersion> versions();

    public List<ViewHistoryEntry> history();

    public Map<String, String> properties();

    public List<MetadataUpdate> changes();

    @Nullable
    public String metadataFileLocation();

    default public ViewVersion version(int versionId) {
        return this.versionsById().get(versionId);
    }

    default public ViewVersion currentVersion() {
        Preconditions.checkArgument(this.versionsById().containsKey(this.currentVersionId()), "Cannot find current version %s in view versions: %s", this.currentVersionId(), this.versionsById().keySet());
        return this.versionsById().get(this.currentVersionId());
    }

    @Value.Derived
    default public Map<Integer, ViewVersion> versionsById() {
        ImmutableMap.Builder<Integer, ViewVersion> builder = ImmutableMap.builder();
        for (ViewVersion version : this.versions()) {
            builder.put(version.versionId(), version);
        }
        return builder.build();
    }

    @Value.Derived
    default public Map<Integer, Schema> schemasById() {
        ImmutableMap.Builder<Integer, Schema> builder = ImmutableMap.builder();
        for (Schema schema : this.schemas()) {
            builder.put(schema.schemaId(), schema);
        }
        return builder.build();
    }

    default public Schema schema() {
        return this.schemasById().get(this.currentSchemaId());
    }

    @Value.Check
    default public void check() {
        Preconditions.checkArgument(this.formatVersion() > 0 && this.formatVersion() <= 1, "Unsupported format version: %s", this.formatVersion());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(ViewMetadata base) {
        return new Builder(base);
    }

    public static class Builder {
        private static final int INITIAL_SCHEMA_ID = 0;
        private static final int LAST_ADDED = -1;
        private final List<ViewVersion> versions;
        private final List<Schema> schemas;
        private final List<ViewHistoryEntry> history;
        private final Map<String, String> properties;
        private final List<MetadataUpdate> changes;
        private int formatVersion = 1;
        private int currentVersionId;
        private String location;
        private String uuid;
        private String metadataLocation;
        private Integer lastAddedVersionId = null;
        private Integer lastAddedSchemaId = null;
        private ViewHistoryEntry historyEntry = null;
        private ViewVersion previousViewVersion = null;
        private final Map<Integer, ViewVersion> versionsById;
        private final Map<Integer, Schema> schemasById;

        private Builder() {
            this.versions = Lists.newArrayList();
            this.versionsById = Maps.newHashMap();
            this.schemas = Lists.newArrayList();
            this.schemasById = Maps.newHashMap();
            this.history = Lists.newArrayList();
            this.properties = Maps.newHashMap();
            this.changes = Lists.newArrayList();
            this.uuid = null;
        }

        private Builder(ViewMetadata base) {
            this.versions = Lists.newArrayList(base.versions());
            this.versionsById = Maps.newHashMap(base.versionsById());
            this.schemas = Lists.newArrayList(base.schemas());
            this.schemasById = Maps.newHashMap(base.schemasById());
            this.history = Lists.newArrayList(base.history());
            this.properties = Maps.newHashMap(base.properties());
            this.changes = Lists.newArrayList();
            this.formatVersion = base.formatVersion();
            this.currentVersionId = base.currentVersionId();
            this.location = base.location();
            this.uuid = base.uuid();
            this.metadataLocation = null;
            this.previousViewVersion = base.currentVersion();
        }

        public Builder upgradeFormatVersion(int newFormatVersion) {
            Preconditions.checkArgument(newFormatVersion >= this.formatVersion, "Cannot downgrade v%s view to v%s", this.formatVersion, newFormatVersion);
            if (this.formatVersion == newFormatVersion) {
                return this;
            }
            this.formatVersion = newFormatVersion;
            this.changes.add(new MetadataUpdate.UpgradeFormatVersion(newFormatVersion));
            return this;
        }

        public Builder setLocation(String newLocation) {
            Preconditions.checkArgument(null != newLocation, "Invalid location: null");
            if (null != this.location && this.location.equals(newLocation)) {
                return this;
            }
            this.location = newLocation;
            this.changes.add(new MetadataUpdate.SetLocation(newLocation));
            return this;
        }

        public Builder setMetadataLocation(String newMetadataLocation) {
            this.metadataLocation = newMetadataLocation;
            return this;
        }

        public Builder setCurrentVersionId(int newVersionId) {
            if (newVersionId == -1) {
                ValidationException.check(this.lastAddedVersionId != null, "Cannot set last version id: no current version id has been set", new Object[0]);
                return this.setCurrentVersionId(this.lastAddedVersionId);
            }
            if (this.currentVersionId == newVersionId) {
                return this;
            }
            ViewVersion version = this.versionsById.get(newVersionId);
            Preconditions.checkArgument(version != null, "Cannot set current version to unknown version: %s", newVersionId);
            this.currentVersionId = newVersionId;
            if (this.lastAddedVersionId != null && this.lastAddedVersionId == newVersionId) {
                this.changes.add(new MetadataUpdate.SetCurrentViewVersion(-1));
            } else {
                this.changes.add(new MetadataUpdate.SetCurrentViewVersion(newVersionId));
            }
            boolean versionAddedInThisChange = this.changes(MetadataUpdate.AddViewVersion.class).anyMatch(added -> added.viewVersion().versionId() == newVersionId);
            this.historyEntry = ImmutableViewHistoryEntry.builder().timestampMillis(versionAddedInThisChange ? version.timestampMillis() : System.currentTimeMillis()).versionId(version.versionId()).build();
            return this;
        }

        public Builder setCurrentVersion(ViewVersion version, Schema schema) {
            int newSchemaId = this.addSchemaInternal(schema);
            ImmutableViewVersion newVersion = ImmutableViewVersion.builder().from(version).schemaId(newSchemaId).build();
            return this.setCurrentVersionId(this.addVersionInternal(newVersion));
        }

        public Builder addVersion(ViewVersion version) {
            this.addVersionInternal(version);
            return this;
        }

        private int addVersionInternal(ViewVersion newVersion) {
            ViewVersion version;
            int newVersionId = this.reuseOrCreateNewViewVersionId(newVersion);
            if (newVersionId != (version = newVersion).versionId()) {
                version = ImmutableViewVersion.builder().from(version).versionId(newVersionId).build();
            }
            if (this.versionsById.containsKey(newVersionId)) {
                boolean addedInBuilder = this.changes(MetadataUpdate.AddViewVersion.class).anyMatch(added -> added.viewVersion().versionId() == newVersionId);
                this.lastAddedVersionId = addedInBuilder ? Integer.valueOf(newVersionId) : null;
                return newVersionId;
            }
            if (newVersion.schemaId() == -1) {
                ValidationException.check(this.lastAddedSchemaId != null, "Cannot set last added schema: no schema has been added", new Object[0]);
                version = ImmutableViewVersion.builder().from(newVersion).schemaId(this.lastAddedSchemaId).build();
            }
            Preconditions.checkArgument(this.schemasById.containsKey(version.schemaId()), "Cannot add version with unknown schema: %s", version.schemaId());
            HashSet<String> dialects = Sets.newHashSet();
            for (ViewRepresentation repr : version.representations()) {
                if (!(repr instanceof SQLViewRepresentation)) continue;
                SQLViewRepresentation sql = (SQLViewRepresentation)repr;
                Preconditions.checkArgument(dialects.add(sql.dialect().toLowerCase(Locale.ROOT)), "Invalid view version: Cannot add multiple queries for dialect %s", (Object)sql.dialect().toLowerCase(Locale.ROOT));
            }
            this.versions.add(version);
            this.versionsById.put(version.versionId(), version);
            if (null != this.lastAddedSchemaId && version.schemaId() == this.lastAddedSchemaId.intValue()) {
                this.changes.add(new MetadataUpdate.AddViewVersion(ImmutableViewVersion.builder().from(version).schemaId(-1).build()));
            } else {
                this.changes.add(new MetadataUpdate.AddViewVersion(version));
            }
            this.lastAddedVersionId = newVersionId;
            return newVersionId;
        }

        private int reuseOrCreateNewViewVersionId(ViewVersion viewVersion) {
            int newVersionId = viewVersion.versionId();
            for (ViewVersion version : this.versions) {
                if (this.sameViewVersion(version, viewVersion)) {
                    return version.versionId();
                }
                if (version.versionId() < newVersionId) continue;
                newVersionId = version.versionId() + 1;
            }
            return newVersionId;
        }

        private boolean sameViewVersion(ViewVersion one, ViewVersion two) {
            return Objects.equals(one.summary(), two.summary()) && Objects.equals(one.representations(), two.representations()) && Objects.equals(one.defaultCatalog(), two.defaultCatalog()) && Objects.equals(one.defaultNamespace(), two.defaultNamespace()) && one.schemaId() == two.schemaId();
        }

        public Builder addSchema(Schema schema) {
            this.addSchemaInternal(schema);
            return this;
        }

        private int addSchemaInternal(Schema schema) {
            int newSchemaId = this.reuseOrCreateNewSchemaId(schema);
            if (this.schemasById.containsKey(newSchemaId)) {
                return newSchemaId;
            }
            Schema newSchema = newSchemaId != schema.schemaId() ? new Schema(newSchemaId, schema.columns(), schema.identifierFieldIds()) : schema;
            this.schemas.add(newSchema);
            this.schemasById.put(newSchema.schemaId(), newSchema);
            this.changes.add(new MetadataUpdate.AddSchema(newSchema));
            this.lastAddedSchemaId = newSchemaId;
            return newSchemaId;
        }

        private int reuseOrCreateNewSchemaId(Schema newSchema) {
            int newSchemaId = 0;
            for (Schema schema : this.schemas) {
                if (schema.sameSchema(newSchema)) {
                    return schema.schemaId();
                }
                if (schema.schemaId() < newSchemaId) continue;
                newSchemaId = schema.schemaId() + 1;
            }
            return newSchemaId;
        }

        public Builder setProperties(Map<String, String> updated) {
            if (updated.isEmpty()) {
                return this;
            }
            this.properties.putAll(updated);
            this.changes.add(new MetadataUpdate.SetProperties(updated));
            return this;
        }

        public Builder removeProperties(Set<String> propertiesToRemove) {
            if (propertiesToRemove.isEmpty()) {
                return this;
            }
            propertiesToRemove.forEach(this.properties::remove);
            this.changes.add(new MetadataUpdate.RemoveProperties(propertiesToRemove));
            return this;
        }

        public Builder assignUUID(String newUUID) {
            Preconditions.checkArgument(newUUID != null, "Cannot set uuid to null");
            Preconditions.checkArgument(this.uuid == null || newUUID.equals(this.uuid), "Cannot reassign uuid");
            if (!newUUID.equals(this.uuid)) {
                this.uuid = newUUID;
                this.changes.add(new MetadataUpdate.AssignUUID(this.uuid));
            }
            return this;
        }

        public ViewMetadata build() {
            List<ViewHistoryEntry> retainedHistory;
            List<ViewVersion> retainedVersions;
            int historySize;
            Preconditions.checkArgument(null != this.location, "Invalid location: null");
            Preconditions.checkArgument(!this.versions.isEmpty(), "Invalid view: no versions were added");
            Preconditions.checkArgument(this.metadataLocation == null || this.changes.isEmpty(), "Cannot create view metadata with a metadata location and changes");
            if (null != this.historyEntry) {
                this.history.add(this.historyEntry);
            }
            if (null != this.previousViewVersion && !PropertyUtil.propertyAsBoolean(this.properties, "replace.drop-dialect.allowed", false)) {
                this.checkIfDialectIsDropped(this.previousViewVersion, this.versionsById.get(this.currentVersionId));
            }
            Preconditions.checkArgument((historySize = PropertyUtil.propertyAsInt(this.properties, "version.history.num-entries", 10)) > 0, "%s must be positive but was %s", (Object)"version.history.num-entries", historySize);
            int numVersions = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)this.changes(MetadataUpdate.AddViewVersion.class).map(v -> v.viewVersion().versionId()).collect(Collectors.toSet()))).add((Object)this.currentVersionId)).build().size();
            int numVersionsToKeep = Math.max(numVersions, historySize);
            if (this.versions.size() > numVersionsToKeep) {
                retainedVersions = Builder.expireVersions(this.versionsById, numVersionsToKeep, this.versionsById.get(this.currentVersionId));
                Set<Integer> retainedVersionIds = retainedVersions.stream().map(ViewVersion::versionId).collect(Collectors.toSet());
                retainedHistory = Builder.updateHistory(this.history, retainedVersionIds);
            } else {
                retainedVersions = this.versions;
                retainedHistory = this.history;
            }
            return ImmutableViewMetadata.of(null == this.uuid ? UUID.randomUUID().toString() : this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, retainedVersions, retainedHistory, this.properties, this.changes, this.metadataLocation);
        }

        @VisibleForTesting
        static List<ViewVersion> expireVersions(Map<Integer, ViewVersion> versionsById, int numVersionsToKeep, ViewVersion currentVersion) {
            ArrayList<Integer> ids = Lists.newArrayList(versionsById.keySet());
            ids.sort(Comparator.reverseOrder());
            ArrayList<ViewVersion> retainedVersions = Lists.newArrayList();
            retainedVersions.add(currentVersion);
            Iterator iterator2 = ids.subList(0, numVersionsToKeep).iterator();
            while (iterator2.hasNext()) {
                int idToKeep = (Integer)iterator2.next();
                if (retainedVersions.size() == numVersionsToKeep) break;
                ViewVersion version = versionsById.get(idToKeep);
                if (currentVersion.versionId() == version.versionId()) continue;
                retainedVersions.add(version);
            }
            return retainedVersions;
        }

        @VisibleForTesting
        static List<ViewHistoryEntry> updateHistory(List<ViewHistoryEntry> history, Set<Integer> ids) {
            ArrayList<ViewHistoryEntry> retainedHistory = Lists.newArrayList();
            for (ViewHistoryEntry entry : history) {
                if (ids.contains(entry.versionId())) {
                    retainedHistory.add(entry);
                    continue;
                }
                retainedHistory.clear();
            }
            return retainedHistory;
        }

        private <U extends MetadataUpdate> Stream<U> changes(Class<U> updateClass) {
            return this.changes.stream().filter(updateClass::isInstance).map(updateClass::cast);
        }

        private void checkIfDialectIsDropped(ViewVersion previous, ViewVersion current) {
            Set<String> baseDialects = this.sqlDialectsFor(previous);
            Set<String> updatedDialects = this.sqlDialectsFor(current);
            Preconditions.checkState(updatedDialects.containsAll(baseDialects), "Cannot replace view due to loss of view dialects (%s=false):\nPrevious dialects: %s\nNew dialects: %s", (Object)"replace.drop-dialect.allowed", baseDialects, updatedDialects);
        }

        private Set<String> sqlDialectsFor(ViewVersion viewVersion) {
            HashSet<String> dialects = Sets.newHashSet();
            for (ViewRepresentation repr : viewVersion.representations()) {
                if (!(repr instanceof SQLViewRepresentation)) continue;
                SQLViewRepresentation sql = (SQLViewRepresentation)repr;
                dialects.add(sql.dialect().toLowerCase(Locale.ROOT));
            }
            return dialects;
        }
    }
}

