/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.minhash;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.minhash.MinHashFilter;
import java.util.Map;

public class MinHashFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "minHash";
    private final int hashCount;
    private final int bucketCount;
    private final int hashSetSize;
    private final boolean withRotation;

    public MinHashFilterFactory(Map<String, String> args2) {
        super(args2);
        this.hashCount = this.getInt(args2, "hashCount", 1);
        this.bucketCount = this.getInt(args2, "bucketCount", 512);
        this.hashSetSize = this.getInt(args2, "hashSetSize", 1);
        this.withRotation = this.getBoolean(args2, "withRotation", this.bucketCount > 1);
    }

    public MinHashFilterFactory() {
        throw MinHashFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new MinHashFilter(input, this.hashCount, this.bucketCount, this.hashSetSize, this.withRotation);
    }
}

