/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.LimitTokenOffsetFilter;
import java.util.Map;

public class LimitTokenOffsetFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "limitTokenOffset";
    public static final String MAX_START_OFFSET = "maxStartOffset";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    private int maxStartOffset;
    private boolean consumeAllTokens;

    public LimitTokenOffsetFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxStartOffset = this.requireInt(args2, MAX_START_OFFSET);
        this.consumeAllTokens = this.getBoolean(args2, CONSUME_ALL_TOKENS_KEY, false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public LimitTokenOffsetFilterFactory() {
        throw LimitTokenOffsetFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenOffsetFilter(input, this.maxStartOffset, this.consumeAllTokens);
    }
}

