/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class TruncateTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final int length;

    public TruncateTokenFilter(TokenStream input, int length) {
        super(input);
        if (length < 1) {
            throw new IllegalArgumentException("length parameter must be a positive number: " + length);
        }
        this.length = length;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword() && this.termAttribute.length() > this.length) {
                this.termAttribute.setLength(this.length);
            }
            return true;
        }
        return false;
    }
}

