/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.ngram;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.ngram.NGramTokenFilter;
import java.util.Map;

public class NGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "nGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public NGramFilterFactory(Map<String, String> args2) {
        super(args2);
        this.minGramSize = this.requireInt(args2, "minGramSize");
        this.maxGramSize = this.requireInt(args2, "maxGramSize");
        this.preserveOriginal = this.getBoolean(args2, "preserveOriginal", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public NGramFilterFactory() {
        throw NGramFilterFactory.defaultCtorException();
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new NGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

