/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class PatternTypingFilter
extends TokenFilter {
    private final PatternTypingRule[] replacementAndFlagByPattern;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final FlagsAttribute flagAtt = this.addAttribute(FlagsAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public PatternTypingFilter(TokenStream input, PatternTypingRule ... replacementAndFlagByPattern) {
        super(input);
        if (replacementAndFlagByPattern == null || Stream.of(replacementAndFlagByPattern).anyMatch(Objects::isNull)) {
            throw new NullPointerException("replacementAndFlagByPattern");
        }
        this.replacementAndFlagByPattern = replacementAndFlagByPattern;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            for (PatternTypingRule rule : this.replacementAndFlagByPattern) {
                Matcher matcher = rule.getPattern().matcher(this.termAtt);
                if (!matcher.find()) continue;
                this.typeAtt.setType(matcher.replaceFirst(rule.getTypeTemplate()));
                this.flagAtt.setFlags(rule.getFlags());
                return true;
            }
            return true;
        }
        return false;
    }

    public static class PatternTypingRule {
        private final Pattern pattern;
        private final int flags;
        private final String typeTemplate;

        public PatternTypingRule(Pattern pattern, int flags, String typeTemplate) {
            this.pattern = pattern;
            this.flags = flags;
            this.typeTemplate = typeTemplate;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getTypeTemplate() {
            return this.typeTemplate;
        }
    }
}

