/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.DocValuesLongHashSet;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.NumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

final class SortedNumericDocValuesSetQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(SortedNumericDocValuesSetQuery.class);
    private final String field;
    private final DocValuesLongHashSet numbers;

    SortedNumericDocValuesSetQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        Arrays.sort(numbers);
        this.numbers = new DocValuesLongHashSet(numbers);
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedNumericDocValuesSetQuery that = (SortedNumericDocValuesSetQuery)other;
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.numbers);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.numbers);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesSetQuery.this.field);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesSetQuery.this.field) == null) {
                    return null;
                }
                final SortedNumericDocValues values2 = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesSetQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values2);
                TwoPhaseIterator iterator2 = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= SortedNumericDocValuesSetQuery.this.numbers.minValue && value <= SortedNumericDocValuesSetQuery.this.numbers.maxValue && SortedNumericDocValuesSetQuery.this.numbers.contains(value);
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(values2){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values2.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values2.nextValue();
                            if (value < SortedNumericDocValuesSetQuery.this.numbers.minValue) continue;
                            if (value > SortedNumericDocValuesSetQuery.this.numbers.maxValue) {
                                return false;
                            }
                            if (!SortedNumericDocValuesSetQuery.this.numbers.contains(value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator2);
            }
        };
    }
}

