/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.Facets;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ReaderUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConjunctionUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class FacetCountsWithFilterQuery
extends Facets {
    protected final Query fastMatchQuery;

    protected FacetCountsWithFilterQuery(Query fastMatchQuery) {
        this.fastMatchQuery = fastMatchQuery;
    }

    protected DocIdSetIterator createIterator(FacetsCollector.MatchingDocs hits, DocIdSetIterator ... iterators) throws IOException {
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        allIterators.add(hits.bits.iterator());
        allIterators.addAll(Arrays.asList(iterators));
        if (allIterators.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        if (this.fastMatchQuery != null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(hits.context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s2 = fastMatchWeight.scorer(hits.context);
            if (s2 == null) {
                return null;
            }
            DocIdSetIterator fastMatchQueryIterator = s2.iterator();
            allIterators.add(fastMatchQueryIterator);
        }
        if (allIterators.size() == 1) {
            return (DocIdSetIterator)allIterators.get(0);
        }
        return ConjunctionUtils.intersectIterators(allIterators);
    }
}

