/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.NumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.OrdinalMap;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortField;
import com.dataiku.dss.shadelib.org.apache.lucene.util.LongValues;
import com.dataiku.dss.shadelib.org.apache.lucene.util.NumericUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public interface IndexSorter {
    public ComparableProvider[] getComparableProviders(List<? extends LeafReader> var1) throws IOException;

    public DocComparator getDocComparator(LeafReader var1, int var2) throws IOException;

    public String getProviderName();

    public static final class StringSorter
    implements IndexSorter {
        private final String providerName;
        private final Object missingValue;
        private final int reverseMul;
        private final SortedDocValuesProvider valuesProvider;

        public StringSorter(String providerName, Object missingValue, boolean reverse, SortedDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            SortedDocValues[] values2 = new SortedDocValues[readers.size()];
            for (int i = 0; i < readers.size(); ++i) {
                SortedDocValues sorted2;
                values2[i] = sorted2 = this.valuesProvider.get(readers.get(i));
            }
            OrdinalMap ordinalMap = OrdinalMap.build(null, values2, 0.25f);
            int missingOrd = this.missingValue == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                SortedDocValues readerValues = values2[readerIndex];
                LongValues globalOrds = ordinalMap.getGlobalOrds(readerIndex);
                providers[readerIndex] = docID -> {
                    if (readerValues.advanceExact(docID)) {
                        return globalOrds.get(readerValues.ordValue());
                    }
                    return missingOrd;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            SortedDocValues sorted2 = this.valuesProvider.get(reader);
            int missingOrd = this.missingValue == SortField.STRING_LAST ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int[] ords = new int[maxDoc];
            Arrays.fill(ords, missingOrd);
            while ((docID = sorted2.nextDoc()) != Integer.MAX_VALUE) {
                ords[docID] = sorted2.ordValue();
            }
            return (docID1, docID2) -> this.reverseMul * Integer.compare(ords[docID1], ords[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class DoubleSorter
    implements IndexSorter {
        private final String providerName;
        private final Double missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public DoubleSorter(String providerName, Double missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValueBits = Double.doubleToLongBits(this.missingValue != null ? this.missingValue : 0.0);
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    long valueBits = values2.advanceExact(docID) ? values2.longValue() : missingValueBits;
                    return NumericUtils.sortableDoubleBits(valueBits);
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            double[] values2 = new double[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values2, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = Double.longBitsToDouble(dvs.longValue());
            }
            return (docID1, docID2) -> this.reverseMul * Double.compare(values2[docID1], values2[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class FloatSorter
    implements IndexSorter {
        private final String providerName;
        private final Float missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public FloatSorter(String providerName, Float missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            int missValueBits = Float.floatToIntBits(this.missingValue != null ? this.missingValue.floatValue() : 0.0f);
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    int valueBits = values2.advanceExact(docID) ? (int)values2.longValue() : missValueBits;
                    return NumericUtils.sortableFloatBits(valueBits);
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            float[] values2 = new float[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values2, this.missingValue.floatValue());
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = Float.intBitsToFloat((int)dvs.longValue());
            }
            return (docID1, docID2) -> this.reverseMul * Float.compare(values2[docID1], values2[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class LongSorter
    implements IndexSorter {
        private final String providerName;
        private final Long missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;

        public LongSorter(String providerName, Long missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValue = this.missingValue != null ? this.missingValue : 0L;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    if (values2.advanceExact(docID)) {
                        return values2.longValue();
                    }
                    return missingValue;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            long[] values2 = new long[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values2, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = dvs.longValue();
            }
            return (docID1, docID2) -> this.reverseMul * Long.compare(values2[docID1], values2[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static final class IntSorter
    implements IndexSorter {
        private final Integer missingValue;
        private final int reverseMul;
        private final NumericDocValuesProvider valuesProvider;
        private final String providerName;

        public IntSorter(String providerName, Integer missingValue, boolean reverse, NumericDocValuesProvider valuesProvider) {
            this.missingValue = missingValue;
            this.reverseMul = reverse ? -1 : 1;
            this.valuesProvider = valuesProvider;
            this.providerName = providerName;
        }

        @Override
        public ComparableProvider[] getComparableProviders(List<? extends LeafReader> readers) throws IOException {
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValue = this.missingValue != null ? (long)this.missingValue.intValue() : 0L;
            for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = docID -> {
                    if (values2.advanceExact(docID)) {
                        return values2.longValue();
                    }
                    return missingValue;
                };
            }
            return providers;
        }

        @Override
        public DocComparator getDocComparator(LeafReader reader, int maxDoc) throws IOException {
            int docID;
            NumericDocValues dvs = this.valuesProvider.get(reader);
            int[] values2 = new int[maxDoc];
            if (this.missingValue != null) {
                Arrays.fill(values2, this.missingValue);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = (int)dvs.longValue();
            }
            return (docID1, docID2) -> this.reverseMul * Integer.compare(values2[docID1], values2[docID2]);
        }

        @Override
        public String getProviderName() {
            return this.providerName;
        }
    }

    public static interface SortedDocValuesProvider {
        public SortedDocValues get(LeafReader var1) throws IOException;
    }

    public static interface NumericDocValuesProvider {
        public NumericDocValues get(LeafReader var1) throws IOException;
    }

    public static interface DocComparator {
        public int compare(int var1, int var2);
    }

    public static interface ComparableProvider {
        public long getAsComparableLong(int var1) throws IOException;
    }
}

