/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.MultiFunction;
import java.io.IOException;

public class MinFloatFunction
extends MultiFloatFunction {
    public MinFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "min";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) throws IOException {
        boolean noneFound = true;
        float val = Float.POSITIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            noneFound = false;
            val = Math.min(vals.floatVal(doc), val);
        }
        if (noneFound) {
            return 0.0f;
        }
        return val;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) throws IOException {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

