/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.NumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortField;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortedNumericSelector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SortedNumericSortField;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class MultiValuedDoubleFieldSource
extends DoubleFieldSource {
    protected final SortedNumericSelector.Type selector;

    public MultiValuedDoubleFieldSource(String field, SortedNumericSelector.Type selector) {
        super(field);
        this.selector = selector;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedDoubleFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedDoubleFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.DOUBLE, reverse, this.selector);
    }

    @Override
    public String description() {
        return "double(" + this.field + "," + this.selector.name() + ")";
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric(readerContext.reader(), this.field);
        return SortedNumericSelector.wrap(sortedDv, this.selector, SortField.Type.DOUBLE);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedDoubleFieldSource.class) {
            return false;
        }
        MultiValuedDoubleFieldSource other = (MultiValuedDoubleFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        return h2 += this.selector.hashCode();
    }
}

