/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes;

import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.FieldableNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.QueryNodeImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.parser.EscapeQuerySyntax;
import java.util.List;

public class TokenizedPhraseQueryNode
extends QueryNodeImpl
implements FieldableNode {
    public TokenizedPhraseQueryNode() {
        this.setLeaf(false);
        this.allocate();
    }

    @Override
    public String toString() {
        List<QueryNode> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            return "<tokenizedphrase/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<tokenizedphrase>");
        for (QueryNode child : children) {
            sb.append("\n");
            sb.append(child.toString());
        }
        sb.append("\n</tokenizedphrase>");
        return sb.toString();
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        List<QueryNode> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String filler = "";
        for (QueryNode child : children) {
            sb.append(filler).append(child.toQueryString(escapeSyntaxParser));
            filler = ",";
        }
        return "[TP[" + sb + "]]";
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        TokenizedPhraseQueryNode clone = (TokenizedPhraseQueryNode)super.cloneTree();
        return clone;
    }

    @Override
    public CharSequence getField() {
        List<QueryNode> children = this.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                if (!(child instanceof FieldableNode)) continue;
                return ((FieldableNode)child).getField();
            }
        }
        return null;
    }

    @Override
    public void setField(CharSequence fieldName) {
        List<QueryNode> children = this.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                if (!(child instanceof FieldableNode)) continue;
                ((FieldableNode)child).setField(fieldName);
            }
        }
    }
}

