/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.processors;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.IntervalQueryNode;
import java.util.List;

public class IntervalQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        this.analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        return super.process(queryTree);
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof IntervalQueryNode) {
            IntervalQueryNode intervalQueryNode = (IntervalQueryNode)node;
            if (this.analyzer == null) {
                throw new QueryNodeException(new MessageImpl(QueryParserMessages.ANALYZER_REQUIRED, intervalQueryNode.toString()));
            }
            intervalQueryNode.setAnalyzer(this.analyzer);
        }
        return node;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

