/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.surround.query;

import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MultiTerms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.surround.query.SimpleTerm;
import com.dataiku.dss.shadelib.org.apache.lucene.search.WildcardQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;

public class SrndTruncQuery
extends SimpleTerm {
    private final String truncated;
    private final CompiledAutomaton compiled;

    public SrndTruncQuery(String truncated) {
        super(false);
        this.truncated = truncated;
        this.compiled = new CompiledAutomaton(WildcardQuery.toAutomaton(new Term(null, truncated)), false, true, 10000, true);
    }

    public String getTruncated() {
        return this.truncated;
    }

    @Override
    public String toStringUnquoted() {
        return this.getTruncated();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null) {
            BytesRef br;
            TermsEnum termsEnum = this.compiled.getTermsEnum(terms);
            while ((br = termsEnum.next()) != null) {
                mtv.visitMatchingTerm(new Term(fieldName, BytesRef.deepCopyOf(br)));
            }
        }
    }
}

