/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.xml.builders;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.xml.DOMUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.xml.ParserException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.xml.QueryBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import org.w3c.dom.Element;

public class TermsQueryBuilder
implements QueryBuilder {
    private final Analyzer analyzer;

    public TermsQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String text = DOMUtils.getNonBlankTextOrFail(e);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setMinimumNumberShouldMatch(DOMUtils.getAttribute(e, "minimumNumberShouldMatch", 0));
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, text);){
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            Term term = null;
            ts.reset();
            while (ts.incrementToken()) {
                term = new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef()));
                bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
            }
            ts.end();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error constructing terms from index:" + ioe);
        }
        BooleanQuery q = bq.build();
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new BoostQuery(q, boost);
    }
}

