/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search;

import com.dataiku.dss.shadelib.org.apache.lucene.geo.GeoUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PointValues;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntArrayList;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.NearestNeighbor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FieldDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreDoc;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopFieldDocs;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TotalHits;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import com.dataiku.dss.shadelib.org.apache.lucene.util.SloppyMath;
import java.io.IOException;
import java.util.ArrayList;

public class LatLonPointPrototypeQueries {
    private LatLonPointPrototypeQueries() {
    }

    public static TopFieldDocs nearest(IndexSearcher searcher, String field, double latitude, double longitude, int n) throws IOException {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1; got " + n);
        }
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("searcher must not be null");
        }
        ArrayList<PointValues> readers = new ArrayList<PointValues>();
        IntArrayList docBases = new IntArrayList();
        ArrayList<Bits> liveDocs = new ArrayList<Bits>();
        int totalHits = 0;
        for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
            PointValues points = leaf.reader().getPointValues(field);
            if (points == null) continue;
            totalHits += points.getDocCount();
            readers.add(points);
            docBases.add(leaf.docBase);
            liveDocs.add(leaf.reader().getLiveDocs());
        }
        NearestNeighbor.NearestHit[] hits = NearestNeighbor.nearest(latitude, longitude, readers, liveDocs, docBases, n);
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            NearestNeighbor.NearestHit hit = hits[i];
            double hitDistance = SloppyMath.haversinMeters(hit.distanceSortKey);
            scoreDocs[i] = new FieldDoc(hit.docID, 0.0f, new Object[]{hitDistance});
        }
        return new TopFieldDocs(new TotalHits(totalHits, TotalHits.Relation.EQUAL_TO), scoreDocs, null);
    }
}

