/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerResult;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerTimer;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerTimingType;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerTree;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search.QueryProfilerWeight;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.List;

public class QueryProfilerIndexSearcher
extends IndexSearcher {
    private final QueryProfilerTree profiler = new QueryProfilerTree();

    public QueryProfilerIndexSearcher(IndexReader reader) {
        super(reader);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        this.profiler.startRewriteTime();
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            this.profiler.stopAndAddRewriteTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        Weight weight;
        QueryProfilerBreakdown profile = this.profiler.getProfileBreakdown(query);
        QueryProfilerTimer timer = profile.getTimer(QueryProfilerTimingType.CREATE_WEIGHT);
        timer.start();
        try {
            weight = query.createWeight(this, scoreMode, boost);
        }
        finally {
            timer.stop();
            this.profiler.pollLast();
        }
        return new QueryProfilerWeight(weight, profile);
    }

    public long getRewriteTime() {
        return this.profiler.getRewriteTime();
    }

    public List<QueryProfilerResult> getProfileResult() {
        return this.profiler.getTree();
    }
}

