/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryProfilerResult {
    private final String type;
    private final String description;
    private final Map<String, Long> breakdown;
    private final long totalTime;
    private final List<QueryProfilerResult> children;

    public QueryProfilerResult(String type, String description, Map<String, Long> breakdown, long totalTime, List<QueryProfilerResult> children) {
        this.type = type;
        this.description = description;
        this.breakdown = Objects.requireNonNull(breakdown, "required breakdown argument missing");
        this.children = children == null ? Collections.emptyList() : children;
        this.totalTime = totalTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.breakdown);
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public List<QueryProfilerResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }
}

