/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.ByteVectorValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.AbstractVectorSimilarityQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.KnnCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopDocs;
import com.dataiku.dss.shadelib.org.apache.lucene.search.VectorScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.VectorSimilarityCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class ByteVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final byte[] target;

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field, traversalSimilarity, resultSimilarity, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity) {
        this(field, target, traversalSimilarity, resultSimilarity, null);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity, Query filter) {
        this(field, target, resultSimilarity, resultSimilarity, filter);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity) {
        this(field, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        ByteVectorValues vectorValues = context.reader().getByteVectorValues(this.field);
        if (vectorValues == null) {
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit) throws IOException {
        VectorSimilarityCollector collector = new VectorSimilarityCollector(this.traversalSimilarity, this.resultSimilarity, visitLimit);
        context.reader().searchNearestVectors(this.field, this.target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%d...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field, this.target[0], Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((ByteVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

