/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedSetDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;

public class SortedSetSelector {
    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selector) {
        if (sortedSet.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton(sortedSet);
        if (singleton != null) {
            return singleton;
        }
        switch (selector) {
            case MIN: {
                return new MinValue(sortedSet);
            }
            case MAX: {
                return new MaxValue(sortedSet);
            }
            case MIDDLE_MIN: {
                return new MiddleMinValue(sortedSet);
            }
            case MIDDLE_MAX: {
                return new MiddleMaxValue(sortedSet);
            }
        }
        throw new AssertionError();
    }

    static class MiddleMaxValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MiddleMaxValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                int targetIdx = docValueCount >>> 1;
                for (int i = 0; i < targetIdx; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            } else {
                this.ord = -1;
            }
        }
    }

    static class MiddleMinValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MiddleMinValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                int targetIdx = docValueCount - 1 >>> 1;
                for (int i = 0; i < targetIdx; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            } else {
                this.ord = -1;
            }
        }
    }

    static class MaxValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MaxValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                for (int i = 0; i < docValueCount - 1; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            } else {
                this.ord = -1;
            }
        }
    }

    static class MinValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MinValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            this.ord = this.docID() != Integer.MAX_VALUE ? (int)this.in.nextOrd() : -1;
        }
    }

    public static enum Type {
        MIN,
        MAX,
        MIDDLE_MIN,
        MIDDLE_MAX;

    }
}

