/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.similarities;

import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.Axiomatic;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF2LOG
extends Axiomatic {
    public AxiomaticF2LOG(float s2) {
        super(s2);
    }

    public AxiomaticF2LOG() {
    }

    @Override
    public String toString() {
        return "F2LOG";
    }

    @Override
    protected double tf(BasicStats stats, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double ln(BasicStats stats, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double tfln(BasicStats stats, double freq, double docLen) {
        return freq / (freq + (double)this.s + (double)this.s * docLen / stats.getAvgFieldLength());
    }

    @Override
    protected double idf(BasicStats stats, double freq, double docLen) {
        return Math.log(((double)stats.getNumberOfDocuments() + 1.0) / (double)stats.getDocFreq());
    }

    @Override
    protected double gamma(BasicStats stats, double freq, double docLen) {
        return 0.0;
    }

    @Override
    protected Explanation tfExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tf(stats, freq, docLen)), "tf, term frequency, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation lnExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.ln(stats, freq, docLen)), "ln, document length, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation tflnExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tfln(stats, freq, docLen)), "tfln, mixed term frequency and document length, computed as freq / (freq + s + s * dl / avgdl) from:", Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)stats.getAvgFieldLength()), "avgdl, average length of field across all documents", new Explanation[0]));
    }

    @Override
    protected Explanation idfExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.idf(stats, freq, docLen)), "idf, inverted document frequency computed as log((N + 1) / n) from:", Explanation.match((Number)Float.valueOf(stats.getNumberOfDocuments()), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats.getDocFreq()), "n, number of documents containing term", new Explanation[0]));
    }
}

