/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.similarities;

import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInvertState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexOptions;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectionStatistics;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Explanation;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermStatistics;
import com.dataiku.dss.shadelib.org.apache.lucene.util.SmallFloat;
import java.util.Collections;

public abstract class Similarity {
    private final boolean discountOverlaps;

    public final boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    protected Similarity() {
        this(true);
    }

    protected Similarity(boolean discountOverlaps) {
        this.discountOverlaps = discountOverlaps;
    }

    public long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4(numTerms);
    }

    public abstract SimScorer scorer(float var1, CollectionStatistics var2, TermStatistics ... var3);

    public static abstract class SimScorer {
        protected SimScorer() {
        }

        public abstract float score(float var1, long var2);

        public Explanation explain(Explanation freq, long norm) {
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "score(freq=" + freq.getValue() + "), with freq of:", Collections.singleton(freq));
        }
    }
}

